/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.common.FetchInfo;
import com.google.gerrit.extensions.config.DownloadCommand;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class ChangeEditJson {
    private final DynamicMap<DownloadCommand> downloadCommands;
    private final DynamicMap<DownloadScheme> downloadSchemes;
    private final Provider<CurrentUser> userProvider;

    @Inject
    ChangeEditJson(DynamicMap<DownloadCommand> downloadCommand, DynamicMap<DownloadScheme> downloadSchemes, Provider<CurrentUser> userProvider) {
        this.downloadCommands = downloadCommand;
        this.downloadSchemes = downloadSchemes;
        this.userProvider = userProvider;
    }

    public EditInfo toEditInfo(ChangeEdit edit, boolean downloadCommands) {
        EditInfo out = new EditInfo();
        out.commit = ChangeEditJson.fillCommit(edit.getEditCommit());
        out.baseRevision = edit.getBasePatchSet().getRevision().get();
        out.basePatchSetNumber = edit.getBasePatchSet().getPatchSetId();
        if (downloadCommands) {
            out.fetch = this.fillFetchMap(edit);
        }
        return out;
    }

    private static CommitInfo fillCommit(RevCommit editCommit) {
        CommitInfo commit = new CommitInfo();
        commit.commit = editCommit.toObjectId().getName();
        commit.author = CommonConverters.toGitPerson(editCommit.getAuthorIdent());
        commit.committer = CommonConverters.toGitPerson(editCommit.getCommitterIdent());
        commit.subject = editCommit.getShortMessage();
        commit.message = editCommit.getFullMessage();
        commit.parents = new ArrayList<CommitInfo>(editCommit.getParentCount());
        for (RevCommit p : editCommit.getParents()) {
            CommitInfo i = new CommitInfo();
            i.commit = p.name();
            commit.parents.add(i);
        }
        return commit;
    }

    private Map<String, FetchInfo> fillFetchMap(ChangeEdit edit) {
        LinkedHashMap<String, FetchInfo> r = new LinkedHashMap<String, FetchInfo>();
        for (DynamicMap.Entry<DownloadScheme> entry : this.downloadSchemes) {
            String schemeName = entry.getExportName();
            DownloadScheme scheme = entry.getProvider().get();
            if (!scheme.isEnabled() || scheme.isAuthRequired() && !this.userProvider.get().isIdentifiedUser() || !scheme.isAuthSupported()) continue;
            String projectName = edit.getChange().getProject().get();
            String refName = edit.getRefName();
            FetchInfo fetchInfo = new FetchInfo(scheme.getUrl(projectName), refName);
            r.put(schemeName, fetchInfo);
            ChangeJson.populateFetchMap(scheme, this.downloadCommands, projectName, refName, fetchInfo);
        }
        return r;
    }
}

