/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.events.AssigneeChangedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.extensions.events.AbstractChangeEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AssigneeChanged {
    private static final Logger log = LoggerFactory.getLogger(AssigneeChanged.class);
    private final DynamicSet<AssigneeChangedListener> listeners;
    private final EventUtil util;

    @Inject
    AssigneeChanged(DynamicSet<AssigneeChangedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, Account account, Account oldAssignee, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.accountInfo(account), this.util.accountInfo(oldAssignee), when);
            for (AssigneeChangedListener l : this.listeners) {
                try {
                    l.onAssigneeChanged(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(event, l, e);
                }
            }
        }
        catch (OrmException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractChangeEvent
    implements AssigneeChangedListener.Event {
        private final AccountInfo oldAssignee;

        Event(ChangeInfo change, AccountInfo editor, AccountInfo oldAssignee, Timestamp when) {
            super(change, editor, when, NotifyHandling.ALL);
            this.oldAssignee = oldAssignee;
        }

        @Override
        public AccountInfo getOldAssignee() {
            return this.oldAssignee;
        }
    }
}

