/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.extensions.events.ChangeAbandoned;
import com.google.gerrit.server.mail.send.AbandonedSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(AbandonOp.class);
    private final AbandonedSender.Factory abandonedSenderFactory;
    private final ChangeMessagesUtil cmUtil;
    private final PatchSetUtil psUtil;
    private final ChangeAbandoned changeAbandoned;
    private final String msgTxt;
    private final NotifyHandling notifyHandling;
    private final ListMultimap<RecipientType, Account.Id> accountsToNotify;
    private final Account account;
    private Change change;
    private PatchSet patchSet;
    private ChangeMessage message;

    @Inject
    AbandonOp(AbandonedSender.Factory abandonedSenderFactory, ChangeMessagesUtil cmUtil, PatchSetUtil psUtil, ChangeAbandoned changeAbandoned, @Assisted @Nullable Account account, @Assisted @Nullable String msgTxt, @Assisted NotifyHandling notifyHandling, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.abandonedSenderFactory = abandonedSenderFactory;
        this.cmUtil = cmUtil;
        this.psUtil = psUtil;
        this.changeAbandoned = changeAbandoned;
        this.account = account;
        this.msgTxt = Strings.nullToEmpty(msgTxt);
        this.notifyHandling = notifyHandling;
        this.accountsToNotify = accountsToNotify;
    }

    @Nullable
    public Change getChange() {
        return this.change;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws OrmException, ResourceConflictException {
        this.change = ctx.getChange();
        PatchSet.Id psId = this.change.currentPatchSetId();
        ChangeUpdate update = ctx.getUpdate(psId);
        if (!this.change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + ChangeUtil.status(this.change));
        }
        this.patchSet = this.psUtil.get(ctx.getDb(), ctx.getNotes(), psId);
        this.change.setStatus(Change.Status.ABANDONED);
        this.change.setLastUpdatedOn(ctx.getWhen());
        update.setStatus(this.change.getStatus());
        this.message = this.newMessage(ctx);
        this.cmUtil.addChangeMessage(ctx.getDb(), update, this.message);
        return true;
    }

    private ChangeMessage newMessage(ChangeContext ctx) {
        StringBuilder msg = new StringBuilder();
        msg.append("Abandoned");
        if (!Strings.nullToEmpty(this.msgTxt).trim().isEmpty()) {
            msg.append("\n\n");
            msg.append(this.msgTxt.trim());
        }
        return ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:abandon");
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        try {
            AbandonedSender cm = this.abandonedSenderFactory.create(ctx.getProject(), this.change.getId());
            if (this.account != null) {
                cm.setFrom(this.account.getId());
            }
            cm.setChangeMessage(this.message.getMessage(), ctx.getWhen());
            cm.setNotify(this.notifyHandling);
            cm.setAccountsToNotify(this.accountsToNotify);
            cm.send();
        }
        catch (Exception e) {
            log.error("Cannot email update for change " + this.change.getId(), e);
        }
        this.changeAbandoned.fire(this.change, this.patchSet, this.account, this.msgTxt, ctx.getWhen(), this.notifyHandling);
    }

    public static interface Factory {
        public AbandonOp create(@Assisted @Nullable Account var1, @Assisted @Nullable String var2, @Assisted NotifyHandling var3, @Assisted ListMultimap<RecipientType, Account.Id> var4);
    }
}

