/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.mail.send.MergedSender;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailMerge
implements Runnable,
RequestContext {
    private static final Logger log = LoggerFactory.getLogger(EmailMerge.class);
    private final ExecutorService sendEmailsExecutor;
    private final MergedSender.Factory mergedSenderFactory;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ThreadLocalRequestContext requestContext;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Project.NameKey project;
    private final Change.Id changeId;
    private final Account.Id submitter;
    private final NotifyHandling notifyHandling;
    private final ListMultimap<RecipientType, Account.Id> accountsToNotify;
    private ReviewDb db;

    @Inject
    EmailMerge(@SendEmailExecutor ExecutorService executor, MergedSender.Factory mergedSenderFactory, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext, IdentifiedUser.GenericFactory identifiedUserFactory, @Assisted Project.NameKey project, @Assisted Change.Id changeId, @Assisted @Nullable Account.Id submitter, @Assisted NotifyHandling notifyHandling, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.sendEmailsExecutor = executor;
        this.mergedSenderFactory = mergedSenderFactory;
        this.schemaFactory = schemaFactory;
        this.requestContext = requestContext;
        this.identifiedUserFactory = identifiedUserFactory;
        this.project = project;
        this.changeId = changeId;
        this.submitter = submitter;
        this.notifyHandling = notifyHandling;
        this.accountsToNotify = accountsToNotify;
    }

    public void sendAsync() {
        Future<?> possiblyIgnoredError = this.sendEmailsExecutor.submit(this);
    }

    @Override
    public void run() {
        RequestContext old = this.requestContext.setContext(this);
        try {
            MergedSender cm = this.mergedSenderFactory.create(this.project, this.changeId);
            if (this.submitter != null) {
                cm.setFrom(this.submitter);
            }
            cm.setNotify(this.notifyHandling);
            cm.setAccountsToNotify(this.accountsToNotify);
            cm.send();
        }
        catch (Exception e) {
            log.error("Cannot email merged notification for " + this.changeId, e);
        }
        finally {
            this.requestContext.setContext(old);
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
    }

    public String toString() {
        return "send-email merged";
    }

    @Override
    public CurrentUser getUser() {
        if (this.submitter != null) {
            return this.identifiedUserFactory.create(this.submitter).getRealUser();
        }
        throw new OutOfScopeException("No user on email thread");
    }

    @Override
    public Provider<ReviewDb> getReviewDbProvider() {
        return new Provider<ReviewDb>(){

            @Override
            public ReviewDb get() {
                if (EmailMerge.this.db == null) {
                    try {
                        EmailMerge.this.db = (ReviewDb)EmailMerge.this.schemaFactory.open();
                    }
                    catch (OrmException e) {
                        throw new ProvisionException("Cannot open ReviewDb", e);
                    }
                }
                return EmailMerge.this.db;
            }
        };
    }

    public static interface Factory {
        public EmailMerge create(Project.NameKey var1, Change.Id var2, Account.Id var3, NotifyHandling var4, ListMultimap<RecipientType, Account.Id> var5);
    }
}

