/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.git.CodeReviewCommit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;

public class MergeTip {
    private CodeReviewCommit initialTip;
    private CodeReviewCommit branchTip;
    private Map<ObjectId, ObjectId> mergeResults;

    public MergeTip(@Nullable CodeReviewCommit initialTip, Collection<CodeReviewCommit> toMerge) {
        Preconditions.checkNotNull(toMerge, "toMerge may not be null");
        Preconditions.checkArgument(!toMerge.isEmpty(), "toMerge may not be empty");
        this.initialTip = initialTip;
        this.branchTip = initialTip;
        this.mergeResults = new HashMap<ObjectId, ObjectId>();
        for (CodeReviewCommit commit : toMerge) {
            this.mergeResults.put(commit.copy(), commit.copy());
        }
    }

    public CodeReviewCommit getInitialTip() {
        return this.initialTip;
    }

    public void moveTipTo(CodeReviewCommit newTip, ObjectId mergedFrom) {
        Preconditions.checkArgument(newTip != null);
        this.branchTip = newTip;
        this.mergeResults.put(mergedFrom, newTip.copy());
    }

    public Map<ObjectId, ObjectId> getMergeResults() {
        return this.mergeResults;
    }

    @Nullable
    public CodeReviewCommit getCurrentTip() {
        return this.branchTip;
    }
}

