/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.extensions.events.ChangeMerged;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.mail.send.MergedSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedByPushOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(MergedByPushOp.class);
    private final RequestScopePropagator requestScopePropagator;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final ChangeMessagesUtil cmUtil;
    private final MergedSender.Factory mergedSenderFactory;
    private final PatchSetUtil psUtil;
    private final ExecutorService sendEmailExecutor;
    private final ChangeMerged changeMerged;
    private final PatchSet.Id psId;
    private final String refName;
    private Change change;
    private boolean correctBranch;
    private Provider<PatchSet> patchSetProvider;
    private PatchSet patchSet;
    private PatchSetInfo info;

    @Inject
    MergedByPushOp(PatchSetInfoFactory patchSetInfoFactory, ChangeMessagesUtil cmUtil, MergedSender.Factory mergedSenderFactory, PatchSetUtil psUtil, @SendEmailExecutor ExecutorService sendEmailExecutor, ChangeMerged changeMerged, @Assisted RequestScopePropagator requestScopePropagator, @Assisted PatchSet.Id psId, @Assisted String refName) {
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.cmUtil = cmUtil;
        this.mergedSenderFactory = mergedSenderFactory;
        this.psUtil = psUtil;
        this.sendEmailExecutor = sendEmailExecutor;
        this.changeMerged = changeMerged;
        this.requestScopePropagator = requestScopePropagator;
        this.psId = psId;
        this.refName = refName;
    }

    public String getMergedIntoRef() {
        return this.refName;
    }

    public MergedByPushOp setPatchSetProvider(Provider<PatchSet> patchSetProvider) {
        this.patchSetProvider = Preconditions.checkNotNull(patchSetProvider);
        return this;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws OrmException, IOException {
        this.change = ctx.getChange();
        this.correctBranch = this.refName.equals(this.change.getDest().get());
        if (!this.correctBranch) {
            return false;
        }
        this.patchSet = this.patchSetProvider != null ? this.patchSetProvider.get() : Preconditions.checkNotNull(this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.psId), "patch set %s not found", (Object)this.psId);
        this.info = this.getPatchSetInfo(ctx);
        ChangeUpdate update = ctx.getUpdate(this.psId);
        Change.Status status = this.change.getStatus();
        if (status == Change.Status.MERGED) {
            return true;
        }
        this.change.setCurrentPatchSet(this.info);
        this.change.setStatus(Change.Status.MERGED);
        update.fixStatus(Change.Status.MERGED);
        update.setCurrentPatchSet();
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append("Change has been successfully pushed");
        if (!this.refName.equals(this.change.getDest().get())) {
            msgBuf.append(" into ");
            if (this.refName.startsWith("refs/heads/")) {
                msgBuf.append("branch ");
                msgBuf.append(Repository.shortenRefName(this.refName));
            } else {
                msgBuf.append(this.refName);
            }
        }
        msgBuf.append(".");
        ChangeMessage msg = ChangeMessagesUtil.newMessage(this.psId, ctx.getUser(), ctx.getWhen(), msgBuf.toString(), "autogenerated:gerrit:merged");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, msg);
        PatchSetApproval submitter = ApprovalsUtil.newApproval(this.change.currentPatchSetId(), ctx.getUser(), LabelId.legacySubmit(), 1, ctx.getWhen());
        update.putApproval(submitter.getLabel(), submitter.getValue());
        ctx.getDb().patchSetApprovals().upsert(Collections.singleton(submitter));
        return true;
    }

    @Override
    public void postUpdate(final Context ctx) {
        if (!this.correctBranch) {
            return;
        }
        Future<?> possiblyIgnoredError = this.sendEmailExecutor.submit(this.requestScopePropagator.wrap(new Runnable(){

            @Override
            public void run() {
                try {
                    MergedSender cm = MergedByPushOp.this.mergedSenderFactory.create(ctx.getProject(), MergedByPushOp.this.psId.getParentKey());
                    cm.setFrom(ctx.getAccountId());
                    cm.setPatchSet(MergedByPushOp.this.patchSet, MergedByPushOp.this.info);
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot send email for submitted patch set " + MergedByPushOp.this.psId, e);
                }
            }

            public String toString() {
                return "send-email merged";
            }
        }));
        this.changeMerged.fire(this.change, this.patchSet, ctx.getAccount(), this.patchSet.getRevision().get(), ctx.getWhen());
    }

    private PatchSetInfo getPatchSetInfo(ChangeContext ctx) throws IOException, OrmException {
        RevWalk rw = ctx.getRevWalk();
        RevCommit commit = rw.parseCommit(ObjectId.fromString(Preconditions.checkNotNull(this.patchSet).getRevision().get()));
        return this.patchSetInfoFactory.get(rw, commit, this.psId);
    }

    public static interface Factory {
        public MergedByPushOp create(RequestScopePropagator var1, PatchSet.Id var2, String var3);
    }
}

