/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.git.ValidationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabFile {
    public static Parser TRIM = new Parser(){

        @Override
        public String parse(String str) {
            return str.trim();
        }
    };

    protected static List<Row> parse(String text, String filename, Parser left, Parser right, ValidationError.Sink errors) throws IOException {
        String s;
        ArrayList<Row> rows = new ArrayList<Row>();
        BufferedReader br = new BufferedReader(new StringReader(text));
        int lineNumber = 1;
        while ((s = br.readLine()) != null) {
            if (!s.isEmpty() && !s.startsWith("#")) {
                int tab = s.indexOf(9);
                if (tab < 0) {
                    errors.error(new ValidationError(filename, lineNumber, "missing tab delimiter"));
                } else {
                    Row row = new Row(s.substring(0, tab), s.substring(tab + 1));
                    rows.add(row);
                    if (left != null) {
                        row.left = left.parse(row.left);
                    }
                    if (right != null) {
                        row.right = right.parse(row.right);
                    }
                }
            }
            ++lineNumber;
        }
        return rows;
    }

    protected static Map<String, String> toMap(List<Row> rows) {
        HashMap<String, String> map = new HashMap<String, String>(rows.size());
        for (Row row : rows) {
            map.put(row.left, row.right);
        }
        return map;
    }

    protected static String asText(String left, String right, Map<String, String> entries) {
        if (entries.isEmpty()) {
            return null;
        }
        ArrayList<Row> rows = new ArrayList<Row>(entries.size());
        for (String key : TabFile.sort(entries.keySet())) {
            rows.add(new Row(key, entries.get(key)));
        }
        return TabFile.asText(left, right, rows);
    }

    protected static String asText(String left, String right, List<Row> rows) {
        if (rows.isEmpty()) {
            return null;
        }
        left = "# " + left;
        int leftLen = left.length();
        for (Row row : rows) {
            leftLen = Math.max(leftLen, row.left.length());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(TabFile.pad(leftLen, left));
        buf.append('\t');
        buf.append(right);
        buf.append('\n');
        buf.append('#');
        buf.append('\n');
        for (Row row : rows) {
            buf.append(TabFile.pad(leftLen, row.left));
            buf.append('\t');
            buf.append(row.right);
            buf.append('\n');
        }
        return buf.toString();
    }

    protected static <T extends Comparable<? super T>> List<T> sort(Collection<T> m) {
        ArrayList<T> r = new ArrayList<T>(m);
        Collections.sort(r);
        return r;
    }

    protected static String pad(int len, String src) {
        if (len <= src.length()) {
            return src;
        }
        StringBuilder r = new StringBuilder(len);
        r.append(src);
        while (r.length() < len) {
            r.append(' ');
        }
        return r.toString();
    }

    protected static class Row {
        public String left;
        public String right;

        public Row(String left, String right) {
            this.left = left;
            this.right = right;
        }
    }

    public static interface Parser {
        public String parse(String var1);
    }
}

