/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.metrics.Counter1;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.Histogram1;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.transport.PostUploadHook;

@Singleton
public class UploadPackMetricsHook
implements PostUploadHook {
    private final Counter1<Operation> requestCount;
    private final Timer1<Operation> counting;
    private final Timer1<Operation> compressing;
    private final Timer1<Operation> writing;
    private final Histogram1<Operation> packBytes;

    @Inject
    UploadPackMetricsHook(MetricMaker metricMaker) {
        Field<Operation> operation = Field.ofEnum(Operation.class, "operation");
        this.requestCount = metricMaker.newCounter("git/upload-pack/request_count", new Description("Total number of git-upload-pack requests").setRate().setUnit("requests"), operation);
        this.counting = metricMaker.newTimer("git/upload-pack/phase_counting", new Description("Time spent in the 'Counting...' phase").setCumulative().setUnit("milliseconds"), operation);
        this.compressing = metricMaker.newTimer("git/upload-pack/phase_compressing", new Description("Time spent in the 'Compressing...' phase").setCumulative().setUnit("milliseconds"), operation);
        this.writing = metricMaker.newTimer("git/upload-pack/phase_writing", new Description("Time spent transferring bytes to client").setCumulative().setUnit("milliseconds"), operation);
        this.packBytes = metricMaker.newHistogram("git/upload-pack/pack_bytes", new Description("Distribution of sizes of packs sent to clients").setCumulative().setUnit("bytes"), operation);
    }

    @Override
    public void onPostUpload(PackStatistics stats) {
        Operation op = Operation.FETCH;
        if (stats.getUninterestingObjects() == null || stats.getUninterestingObjects().isEmpty()) {
            op = Operation.CLONE;
        }
        this.requestCount.increment(op);
        this.counting.record(op, stats.getTimeCounting(), TimeUnit.MILLISECONDS);
        this.compressing.record(op, stats.getTimeCompressing(), TimeUnit.MILLISECONDS);
        this.writing.record(op, stats.getTimeWriting(), TimeUnit.MILLISECONDS);
        this.packBytes.record(op, stats.getTotalBytes());
    }

    static enum Operation {
        CLONE,
        FETCH;

    }
}

