/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.git.receive.ReceiveCommitsExecutor;
import com.google.gerrit.server.update.ChangeUpdateExecutor;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

public class ReceiveCommitsExecutorModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @ReceiveCommitsExecutor
    public ExecutorService createReceiveCommitsExecutor(@GerritServerConfig Config config, WorkQueue queues) {
        int poolSize = config.getInt("receive", null, "threadPoolSize", Runtime.getRuntime().availableProcessors());
        return queues.createQueue(poolSize, "ReceiveCommits", true);
    }

    @Provides
    @Singleton
    @SendEmailExecutor
    public ExecutorService createSendEmailExecutor(@GerritServerConfig Config config, WorkQueue queues) {
        int poolSize = config.getInt("sendemail", null, "threadPoolSize", 1);
        if (poolSize == 0) {
            return MoreExecutors.newDirectExecutorService();
        }
        return queues.createQueue(poolSize, "SendEmail", true);
    }

    @Provides
    @Singleton
    @ChangeUpdateExecutor
    public ListeningExecutorService createChangeUpdateExecutor(@GerritServerConfig Config config) {
        int poolSize = config.getInt("receive", null, "changeUpdateThreads", 1);
        if (poolSize <= 1) {
            return MoreExecutors.newDirectExecutorService();
        }
        return MoreExecutors.listeningDecorator(MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, poolSize, 10L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(poolSize), new ThreadFactoryBuilder().setNameFormat("ChangeUpdate-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy())));
    }
}

