/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.annotations.ExtensionPoint;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.RefCache;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gerrit.server.validators.ValidationException;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

@ExtensionPoint
public interface OnSubmitValidationListener {
    public void preBranchUpdate(Arguments var1) throws ValidationException;

    public static class Arguments {
        private Project.NameKey project;
        private RevWalk rw;
        private ImmutableMap<String, ReceiveCommand> commands;
        private RefCache refs;

        Arguments(Project.NameKey project, RevWalk rw, ChainedReceiveCommands commands) {
            this.project = Preconditions.checkNotNull(project);
            this.rw = Preconditions.checkNotNull(rw);
            this.refs = Preconditions.checkNotNull(commands);
            this.commands = ImmutableMap.copyOf(commands.getCommands());
        }

        public Project.NameKey getProject() {
            return this.project;
        }

        public RevWalk getRevWalk() {
            return this.rw;
        }

        public ImmutableMap<String, ReceiveCommand> getCommands() {
            return this.commands;
        }

        public Optional<ObjectId> getRef(String name) throws IOException {
            return this.refs.get(name);
        }
    }
}

