/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.InternalGroup;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;

@Singleton
public class Index
implements RestModifyView<GroupResource, Input> {
    private final GroupCache groupCache;

    @Inject
    Index(GroupCache groupCache) {
        this.groupCache = groupCache;
    }

    public Response<?> apply(GroupResource rsrc, Input input) throws IOException, AuthException, UnprocessableEntityException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("not allowed to index group");
        }
        AccountGroup.UUID groupUuid = rsrc.getGroup().getGroupUUID();
        if (!rsrc.isInternalGroup()) {
            throw new UnprocessableEntityException(String.format("External Group Not Allowed: %s", groupUuid.get()));
        }
        Optional<InternalGroup> group = this.groupCache.get(groupUuid);
        if (group.isPresent()) {
            this.groupCache.evict(group.get().getGroupUUID(), group.get().getId(), group.get().getNameKey());
        }
        return Response.none();
    }

    public static class Input {
    }
}

