/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;

class CommentTimestampAdapter
extends TypeAdapter<Timestamp> {
    private static final DateTimeFormatter FALLBACK = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);

    CommentTimestampAdapter() {
    }

    @Override
    public void write(JsonWriter out, Timestamp ts) throws IOException {
        Timestamp truncated = new Timestamp(ts.getTime() / 1000L * 1000L);
        out.value(DateTimeFormatter.ISO_INSTANT.format(truncated.toInstant()));
    }

    @Override
    public Timestamp read(JsonReader in) throws IOException {
        TemporalAccessor ta;
        String str = in.nextString();
        try {
            ta = DateTimeFormatter.ISO_INSTANT.parse(str);
        }
        catch (DateTimeParseException e) {
            ta = LocalDateTime.from(FALLBACK.parse(str)).atZone(ZoneId.systemDefault());
        }
        return Timestamp.from(Instant.from(ta));
    }
}

