/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.RevisionNote;
import com.google.gerrit.server.notedb.RevisionNoteData;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RevisionNoteBuilder {
    final byte[] baseRaw;
    final List<? extends Comment> baseComments;
    final Map<Comment.Key, Comment> put;
    final Set<Comment.Key> delete;
    private String pushCert;

    RevisionNoteBuilder(RevisionNote<? extends Comment> base) {
        if (base != null) {
            this.baseRaw = base.getRaw();
            this.baseComments = base.getComments();
            this.put = Maps.newHashMapWithExpectedSize(this.baseComments.size());
            if (base instanceof ChangeRevisionNote) {
                this.pushCert = ((ChangeRevisionNote)base).getPushCert();
            }
        } else {
            this.baseRaw = new byte[0];
            this.baseComments = Collections.emptyList();
            this.put = new HashMap<Comment.Key, Comment>();
            this.pushCert = null;
        }
        this.delete = new HashSet<Comment.Key>();
    }

    public byte[] build(ChangeNoteUtil noteUtil, boolean writeJson) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (writeJson) {
            this.buildNoteJson(noteUtil, out);
        } else {
            this.buildNoteLegacy(noteUtil, out);
        }
        return out.toByteArray();
    }

    void putComment(Comment comment) {
        Preconditions.checkArgument(!this.delete.contains(comment.key), "cannot both delete and put %s", (Object)comment.key);
        this.put.put(comment.key, comment);
    }

    void deleteComment(Comment.Key key) {
        Preconditions.checkArgument(!this.put.containsKey(key), "cannot both delete and put %s", (Object)key);
        this.delete.add(key);
    }

    void setPushCertificate(String pushCert) {
        this.pushCert = pushCert;
    }

    private ListMultimap<Integer, Comment> buildCommentMap() {
        Multimap all = MultimapBuilder.hashKeys().arrayListValues().build();
        for (Comment comment : this.baseComments) {
            if (this.delete.contains(comment.key) || this.put.containsKey(comment.key)) continue;
            all.put(comment.key.patchSetId, comment);
        }
        for (Comment comment : this.put.values()) {
            if (this.delete.contains(comment.key)) continue;
            all.put(comment.key.patchSetId, comment);
        }
        return all;
    }

    private void buildNoteJson(ChangeNoteUtil noteUtil, OutputStream out) throws IOException {
        ListMultimap<Integer, Comment> comments = this.buildCommentMap();
        if (comments.isEmpty() && this.pushCert == null) {
            return;
        }
        RevisionNoteData data = new RevisionNoteData();
        data.comments = CommentsUtil.COMMENT_ORDER.sortedCopy(comments.values());
        data.pushCert = this.pushCert;
        try (OutputStreamWriter osw = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            noteUtil.getGson().toJson((Object)data, (Appendable)osw);
        }
    }

    private void buildNoteLegacy(ChangeNoteUtil noteUtil, OutputStream out) throws IOException {
        if (this.pushCert != null) {
            byte[] certBytes = this.pushCert.getBytes(StandardCharsets.UTF_8);
            out.write(certBytes, 0, RevisionNoteBuilder.trimTrailingNewlines(certBytes));
            out.write(10);
        }
        noteUtil.buildNote(this.buildCommentMap(), out);
    }

    private static int trimTrailingNewlines(byte[] bytes) {
        int p;
        for (p = bytes.length; p > 1 && bytes[p - 1] == 10; --p) {
        }
        return p;
    }

    static class Cache {
        private final RevisionNoteMap<? extends RevisionNote<? extends Comment>> revisionNoteMap;
        private final Map<RevId, RevisionNoteBuilder> builders;

        Cache(RevisionNoteMap<? extends RevisionNote<? extends Comment>> revisionNoteMap) {
            this.revisionNoteMap = revisionNoteMap;
            this.builders = new HashMap<RevId, RevisionNoteBuilder>();
        }

        RevisionNoteBuilder get(RevId revId) {
            RevisionNoteBuilder b = this.builders.get(revId);
            if (b == null) {
                b = new RevisionNoteBuilder((RevisionNote)this.revisionNoteMap.revisionNotes.get(revId));
                this.builders.put(revId, b);
            }
            return b;
        }

        Map<RevId, RevisionNoteBuilder> getBuilders() {
            return Collections.unmodifiableMap(this.builders);
        }
    }
}

