/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommentEvent
extends Event {
    private static final Logger log = LoggerFactory.getLogger(CommentEvent.class);
    public final Comment c;
    private final Change change;
    private final PatchSet ps;
    private final PatchListCache cache;

    CommentEvent(Comment c, Change change, PatchSet ps, PatchListCache cache) {
        super(CommentsUtil.getCommentPsId(change.getId(), c), c.author.getId(), c.getRealAuthor().getId(), c.writtenOn, change.getCreatedOn(), c.tag);
        this.c = c;
        this.change = change;
        this.ps = ps;
        this.cache = cache;
    }

    @Override
    boolean uniquePerUpdate() {
        return false;
    }

    @Override
    protected boolean canHaveTag() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) {
        this.checkUpdate(update);
        if (this.c.revId == null) {
            try {
                CommentsUtil.setCommentRevId(this.c, this.cache, this.change, this.ps);
            }
            catch (PatchListNotAvailableException e) {
                log.warn("Unable to determine parent commit of patch set {} ({}); omitting inline comment {}", this.ps.getId(), this.ps.getRevision(), this.c);
                return;
            }
        }
        update.putComment(PatchLineComment.Status.PUBLISHED, this.c);
    }

    @Override
    protected void addToString(MoreObjects.ToStringHelper helper) {
        helper.add("message", this.c.message);
    }
}

