/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.FinalUpdatesEvent;
import com.google.gerrit.server.notedb.rebuild.PatchSetEvent;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class Event
implements Comparable<Event> {
    final Account.Id user;
    final Account.Id realUser;
    final String tag;
    final boolean predatesChange;
    final List<Event> deps;
    Timestamp when;
    PatchSet.Id psId;

    protected Event(PatchSet.Id psId, Account.Id effectiveUser, Account.Id realUser, Timestamp when, Timestamp changeCreatedOn, String tag) {
        this.psId = psId;
        this.user = effectiveUser;
        this.realUser = realUser != null ? realUser : effectiveUser;
        this.tag = tag;
        this.predatesChange = when.before(changeCreatedOn);
        this.when = this.predatesChange ? changeCreatedOn : when;
        this.deps = new ArrayList<Event>();
    }

    protected void checkUpdate(AbstractChangeUpdate update) {
        Preconditions.checkState(Objects.equals(update.getPatchSetId(), this.psId), "cannot apply event for %s to update for %s", (Object)update.getPatchSetId(), (Object)this.psId);
        Preconditions.checkState(this.when.getTime() - update.getWhen().getTime() <= ChangeRebuilderImpl.MAX_WINDOW_MS, "event at %s outside update window starting at %s", (Object)this.when, (Object)update.getWhen());
        Preconditions.checkState(Objects.equals(update.getNullableAccountId(), this.user), "cannot apply event by %s to update by %s", (Object)this.user, (Object)update.getNullableAccountId());
    }

    Event addDep(Event e) {
        this.deps.add(e);
        return this;
    }

    abstract boolean uniquePerUpdate();

    abstract void apply(ChangeUpdate var1) throws OrmException, IOException;

    protected boolean isPostSubmitApproval() {
        return false;
    }

    protected boolean isSubmit() {
        return false;
    }

    protected boolean canHaveTag() {
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("psId", this.psId).add("effectiveUser", this.user).add("realUser", this.realUser).add("when", this.when).add("tag", this.tag);
        this.addToString(helper);
        return helper.toString();
    }

    protected void addToString(MoreObjects.ToStringHelper helper) {
    }

    @Override
    public int compareTo(Event other) {
        return ComparisonChain.start().compareFalseFirst(this.isFinalUpdates(), other.isFinalUpdates()).compare(this.when, other.when).compareTrueFirst(this.isPatchSet(), this.isPatchSet()).compareTrueFirst(this.predatesChange, other.predatesChange).compare(this.user, other.user, ReviewDbUtil.intKeyOrdering()).compare(this.realUser, other.realUser, ReviewDbUtil.intKeyOrdering()).compare(this.psId, other.psId, ReviewDbUtil.intKeyOrdering().nullsLast()).result();
    }

    private boolean isPatchSet() {
        return this instanceof PatchSetEvent;
    }

    private boolean isFinalUpdates() {
        return this instanceof FinalUpdatesEvent;
    }
}

