/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.common.FormatUtil;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.reviewdb.server.ReviewDbWrapper;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfigProvider;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.notedb.ChangeBundleReader;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.MutableNotesMigration;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.NotesMigrationState;
import com.google.gerrit.server.notedb.PrimaryStorageMigrator;
import com.google.gerrit.server.notedb.RepoSequence;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.ConflictingUpdateException;
import com.google.gerrit.server.notedb.rebuild.MigrationException;
import com.google.gerrit.server.notedb.rebuild.NotesMigrationStateListener;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gerrit.server.update.RefUpdateUtil;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoteDbMigrator
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(NoteDbMigrator.class);
    private static final String AUTO_MIGRATE = "autoMigrate";
    private static final String TRIAL = "trial";
    private final FileBasedConfig gerritConfig;
    private final FileBasedConfig noteDbConfig;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final Provider<PersonIdent> serverIdent;
    private final AllUsersName allUsers;
    private final GitRepositoryManager repoManager;
    private final NoteDbUpdateManager.Factory updateManagerFactory;
    private final ChangeBundleReader bundleReader;
    private final AllProjectsName allProjects;
    private final ThreadLocalRequestContext requestContext;
    private final InternalUser.Factory userFactory;
    private final ChangeRebuilderImpl rebuilder;
    private final MutableNotesMigration globalNotesMigration;
    private final PrimaryStorageMigrator primaryStorageMigrator;
    private final DynamicSet<NotesMigrationStateListener> listeners;
    private final ListeningExecutorService executor;
    private final ImmutableList<Project.NameKey> projects;
    private final ImmutableList<Change.Id> changes;
    private final OutputStream progressOut;
    private final NotesMigrationState stopAtState;
    private final boolean trial;
    private final boolean forceRebuild;
    private final int sequenceGap;
    private final boolean autoMigrate;

    public static boolean getAutoMigrate(Config cfg) {
        return cfg.getBoolean("noteDb", NoteDbTable.CHANGES.key(), AUTO_MIGRATE, false);
    }

    private static void setAutoMigrate(Config cfg, boolean autoMigrate) {
        cfg.setBoolean("noteDb", NoteDbTable.CHANGES.key(), AUTO_MIGRATE, autoMigrate);
    }

    public static boolean getTrialMode(Config cfg) {
        return cfg.getBoolean("noteDb", NoteDbTable.CHANGES.key(), TRIAL, false);
    }

    public static void setTrialMode(Config cfg, boolean trial) {
        cfg.setBoolean("noteDb", NoteDbTable.CHANGES.key(), TRIAL, trial);
    }

    private NoteDbMigrator(SitePaths sitePaths, SchemaFactory<ReviewDb> schemaFactory, Provider<PersonIdent> serverIdent, AllUsersName allUsers, GitRepositoryManager repoManager, NoteDbUpdateManager.Factory updateManagerFactory, ChangeBundleReader bundleReader, AllProjectsName allProjects, ThreadLocalRequestContext requestContext, InternalUser.Factory userFactory, ChangeRebuilderImpl rebuilder, MutableNotesMigration globalNotesMigration, PrimaryStorageMigrator primaryStorageMigrator, DynamicSet<NotesMigrationStateListener> listeners, ListeningExecutorService executor, ImmutableList<Project.NameKey> projects, ImmutableList<Change.Id> changes, OutputStream progressOut, NotesMigrationState stopAtState, boolean trial, boolean forceRebuild, int sequenceGap, boolean autoMigrate) throws MigrationException {
        if (!changes.isEmpty() && !projects.isEmpty()) {
            throw new MigrationException("Cannot set both changes and projects");
        }
        if (sequenceGap < 0) {
            throw new MigrationException("Sequence gap must be non-negative: " + sequenceGap);
        }
        this.schemaFactory = schemaFactory;
        this.serverIdent = serverIdent;
        this.allUsers = allUsers;
        this.rebuilder = rebuilder;
        this.repoManager = repoManager;
        this.updateManagerFactory = updateManagerFactory;
        this.bundleReader = bundleReader;
        this.allProjects = allProjects;
        this.requestContext = requestContext;
        this.userFactory = userFactory;
        this.globalNotesMigration = globalNotesMigration;
        this.primaryStorageMigrator = primaryStorageMigrator;
        this.listeners = listeners;
        this.executor = executor;
        this.projects = projects;
        this.changes = changes;
        this.progressOut = progressOut;
        this.stopAtState = stopAtState;
        this.trial = trial;
        this.forceRebuild = forceRebuild;
        this.sequenceGap = sequenceGap;
        this.autoMigrate = autoMigrate;
        this.gerritConfig = new FileBasedConfig(sitePaths.gerrit_config.toFile(), FS.detect());
        this.noteDbConfig = new FileBasedConfig(this.gerritConfig, sitePaths.notedb_config.toFile(), FS.detect());
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    public void migrate() throws OrmException, IOException {
        if (!this.changes.isEmpty() || !this.projects.isEmpty()) {
            throw new MigrationException("Cannot set changes or projects during full migration; call rebuild() instead");
        }
        Optional<NotesMigrationState> maybeState = this.loadState();
        if (!maybeState.isPresent()) {
            throw new MigrationException("Could not determine initial migration state");
        }
        NotesMigrationState state = maybeState.get();
        if (this.trial && state.compareTo(NotesMigrationState.READ_WRITE_NO_SEQUENCE) > 0) {
            throw new MigrationException("Migration has already progressed past the endpoint of the \"trial mode\" state; NoteDb is already the primary storage for some changes");
        }
        if (this.forceRebuild && state.compareTo(NotesMigrationState.READ_WRITE_WITH_SEQUENCE_REVIEW_DB_PRIMARY) > 0) {
            throw new MigrationException("Cannot force rebuild changes; NoteDb is already the primary storage for some changes");
        }
        this.setControlFlags();
        boolean rebuilt = false;
        block8: while (state.compareTo(NotesMigrationState.NOTE_DB) < 0) {
            boolean stillNeedsRebuild;
            if (state.equals((Object)this.stopAtState)) {
                return;
            }
            boolean bl = stillNeedsRebuild = this.forceRebuild && !rebuilt;
            if (this.trial && state.compareTo(NotesMigrationState.READ_WRITE_NO_SEQUENCE) >= 0 && (!stillNeedsRebuild || state != NotesMigrationState.READ_WRITE_NO_SEQUENCE)) {
                return;
            }
            switch (state) {
                case REVIEW_DB: {
                    state = this.turnOnWrites(state);
                    continue block8;
                }
                case WRITE: {
                    state = this.rebuildAndEnableReads(state);
                    rebuilt = true;
                    continue block8;
                }
                case READ_WRITE_NO_SEQUENCE: {
                    if (stillNeedsRebuild) {
                        state = this.rebuildAndEnableReads(state);
                        rebuilt = true;
                        continue block8;
                    }
                    state = this.enableSequences(state);
                    continue block8;
                }
                case READ_WRITE_WITH_SEQUENCE_REVIEW_DB_PRIMARY: {
                    if (stillNeedsRebuild) {
                        state = this.rebuildAndEnableReads(state);
                        rebuilt = true;
                        continue block8;
                    }
                    state = this.setNoteDbPrimary(state);
                    continue block8;
                }
                case READ_WRITE_WITH_SEQUENCE_NOTE_DB_PRIMARY: {
                    state = this.setNoteDbPrimary(state);
                    continue block8;
                }
                case NOTE_DB: {
                    continue block8;
                }
            }
            throw new MigrationException("Migration out of the following state is not supported:\n" + state.toText());
        }
    }

    private NotesMigrationState turnOnWrites(NotesMigrationState prev) throws IOException {
        return this.saveState(prev, NotesMigrationState.WRITE);
    }

    private NotesMigrationState rebuildAndEnableReads(NotesMigrationState prev) throws OrmException, IOException {
        this.rebuild();
        return this.saveState(prev, NotesMigrationState.READ_WRITE_NO_SEQUENCE);
    }

    private NotesMigrationState enableSequences(NotesMigrationState prev) throws OrmException, IOException {
        try (ReviewDb db = this.schemaFactory.open();){
            int nextChangeId = db.nextChangeId();
            RepoSequence seq = new RepoSequence(this.repoManager, GitReferenceUpdated.DISABLED, this.allProjects, "changes", () -> nextChangeId + this.sequenceGap - 1, 1, nextChangeId);
            seq.next();
        }
        return this.saveState(prev, NotesMigrationState.READ_WRITE_WITH_SEQUENCE_REVIEW_DB_PRIMARY);
    }

    private NotesMigrationState setNoteDbPrimary(NotesMigrationState prev) throws MigrationException, OrmException, IOException {
        List allChanges;
        Preconditions.checkState(this.projects.isEmpty() && this.changes.isEmpty(), "Should not have attempted setNoteDbPrimary with a subset of changes");
        Preconditions.checkState(prev == NotesMigrationState.READ_WRITE_WITH_SEQUENCE_REVIEW_DB_PRIMARY || prev == NotesMigrationState.READ_WRITE_WITH_SEQUENCE_NOTE_DB_PRIMARY, "Unexpected start state for setNoteDbPrimary: %s", (Object)prev);
        prev = this.saveState(prev, NotesMigrationState.READ_WRITE_WITH_SEQUENCE_NOTE_DB_PRIMARY);
        Stopwatch sw = Stopwatch.createStarted();
        log.info("Setting primary storage to NoteDb");
        try (ReviewDb db = ReviewDbUtil.unwrapDb(this.schemaFactory.open());){
            allChanges = Streams.stream(db.changes().all()).map(Change::getId).collect(Collectors.toList());
        }
        var5_4 = null;
        try (ContextHelper contextHelper = new ContextHelper();){
            List<ListenableFuture<Boolean>> futures = allChanges.stream().map(id -> this.executor.submit(() -> {
                Boolean bl;
                block11: {
                    ManualRequestContext ctx = contextHelper.open();
                    Throwable throwable = null;
                    try {
                        try {
                            this.primaryStorageMigrator.migrateToNoteDbPrimary((Change.Id)id);
                        }
                        catch (PrimaryStorageMigrator.NoNoteDbStateException e) {
                            if (NoteDbMigrator.canSkipPrimaryStorageMigration(ctx.getReviewDbProvider().get(), id)) {
                                log.warn("Change {} previously failed to rebuild; skipping primary storage migration", id, (Object)e);
                            }
                            throw e;
                        }
                        bl = true;
                        if (ctx == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (ctx != null) {
                                    NoteDbMigrator.$closeResource(throwable, ctx);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            log.error("Error migrating primary storage for " + id, e);
                            return false;
                        }
                    }
                    NoteDbMigrator.$closeResource(throwable, ctx);
                }
                return bl;
            })).collect(Collectors.toList());
            boolean ok = NoteDbMigrator.futuresToBoolean(futures, "Error migrating primary storage");
            double t = (double)sw.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            log.info(String.format("Migrated primary storage of %d changes in %.01fs (%.01f/s)\n", allChanges.size(), t, (double)allChanges.size() / t));
            if (!ok) {
                throw new MigrationException("Migrating primary storage for some changes failed, see log");
            }
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        return this.disableReviewDb(prev);
    }

    private static boolean canSkipPrimaryStorageMigration(ReviewDb db, Change.Id id) {
        try {
            return Iterables.isEmpty(ReviewDbUtil.unwrapDb(db).patchSets().byChange(id));
        }
        catch (Exception e) {
            log.error("Error checking if change " + id + " can be skipped, assuming no", e);
            return false;
        }
    }

    private NotesMigrationState disableReviewDb(NotesMigrationState prev) throws IOException {
        return this.saveState(prev, NotesMigrationState.NOTE_DB, c -> NoteDbMigrator.setAutoMigrate(c, false));
    }

    private Optional<NotesMigrationState> loadState() throws IOException {
        try {
            this.gerritConfig.load();
            this.noteDbConfig.load();
            return NotesMigrationState.forConfig(this.noteDbConfig);
        }
        catch (IllegalArgumentException | ConfigInvalidException e) {
            log.warn("error reading NoteDb migration options from " + this.noteDbConfig.getFile(), e);
            return Optional.empty();
        }
    }

    private NotesMigrationState saveState(NotesMigrationState expectedOldState, NotesMigrationState newState) throws IOException {
        return this.saveState(expectedOldState, newState, c -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotesMigrationState saveState(NotesMigrationState expectedOldState, NotesMigrationState newState, Consumer<Config> additionalUpdates) throws IOException {
        MutableNotesMigration mutableNotesMigration = this.globalNotesMigration;
        synchronized (mutableNotesMigration) {
            Optional<NotesMigrationState> actualOldState = this.loadState();
            if (!actualOldState.equals(Optional.of(expectedOldState))) {
                throw new MigrationException("Cannot move to new state:\n" + newState.toText() + "\n\nExpected this state in gerrit.config:\n" + expectedOldState.toText() + "\n\n" + (actualOldState.isPresent() ? "But found this state:\n" + actualOldState.get().toText() : "But could not parse the current state"));
            }
            this.preStateChange(expectedOldState, newState);
            newState.setConfigValues(this.noteDbConfig);
            additionalUpdates.accept(this.noteDbConfig);
            this.noteDbConfig.save();
            this.globalNotesMigration.setFrom(newState);
            log.info("Migration state: {} => {}", (Object)expectedOldState, (Object)newState);
            return newState;
        }
    }

    private void preStateChange(NotesMigrationState oldState, NotesMigrationState newState) throws IOException {
        for (NotesMigrationStateListener listener : this.listeners) {
            listener.preStateChange(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setControlFlags() throws MigrationException {
        MutableNotesMigration mutableNotesMigration = this.globalNotesMigration;
        synchronized (mutableNotesMigration) {
            try {
                this.noteDbConfig.load();
                NoteDbMigrator.setAutoMigrate(this.noteDbConfig, this.autoMigrate);
                NoteDbMigrator.setTrialMode(this.noteDbConfig, this.trial);
                this.noteDbConfig.save();
            }
            catch (IOException | ConfigInvalidException e) {
                throw new MigrationException("Error saving auto-migration config", e);
            }
        }
    }

    public void rebuild() throws MigrationException, OrmException {
        if (!this.globalNotesMigration.commitChangeWrites()) {
            throw new MigrationException("Cannot rebuild without noteDb.changes.write=true");
        }
        Stopwatch sw = Stopwatch.createStarted();
        log.info("Rebuilding changes in NoteDb");
        ImmutableListMultimap<Project.NameKey, Change.Id> changesByProject = this.getChangesByProject();
        ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>();
        try (ContextHelper contextHelper = new ContextHelper();){
            List projectNames = Ordering.usingToString().sortedCopy(changesByProject.keySet());
            for (Project.NameKey project : projectNames) {
                Future future = this.executor.submit(() -> {
                    try {
                        return this.rebuildProject(contextHelper.getReviewDb(), changesByProject, project);
                    }
                    catch (Exception e) {
                        log.error("Error rebuilding project " + project, e);
                        return false;
                    }
                });
                futures.add((ListenableFuture<Boolean>)future);
            }
            boolean ok = NoteDbMigrator.futuresToBoolean(futures, "Error rebuilding projects");
            double t = (double)sw.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            log.info(String.format("Rebuilt %d changes in %.01fs (%.01f/s)\n", changesByProject.size(), t, (double)changesByProject.size() / t));
            if (!ok) {
                throw new MigrationException("Rebuilding some changes failed, see log");
            }
        }
    }

    private ImmutableListMultimap<Project.NameKey, Change.Id> getChangesByProject() throws OrmException {
        SetMultimap out = MultimapBuilder.treeKeys(Comparator.comparing(Project.NameKey::get)).treeSetValues(Comparator.comparing(Change.Id::get)).build();
        try (ReviewDb db = ReviewDbUtil.unwrapDb(this.schemaFactory.open());){
            if (!this.projects.isEmpty()) {
                ImmutableListMultimap<Project.NameKey, Change.Id> immutableListMultimap = NoteDbMigrator.byProject(db.changes().all(), c -> this.projects.contains(c.getProject()), out);
                return immutableListMultimap;
            }
            if (!this.changes.isEmpty()) {
                ImmutableListMultimap<Project.NameKey, Change.Id> immutableListMultimap = NoteDbMigrator.byProject(db.changes().get(this.changes), c -> true, out);
                return immutableListMultimap;
            }
            ImmutableListMultimap<Project.NameKey, Change.Id> immutableListMultimap = NoteDbMigrator.byProject(db.changes().all(), c -> true, out);
            return immutableListMultimap;
        }
    }

    private static ImmutableListMultimap<Project.NameKey, Change.Id> byProject(Iterable<Change> changes, Predicate<Change> pred, SetMultimap<Project.NameKey, Change.Id> out) {
        Streams.stream(changes).filter(pred).forEach(c -> out.put(c.getProject(), c.getId()));
        return ImmutableListMultimap.copyOf(out);
    }

    private static ObjectInserter newPackInserter(Repository repo) {
        if (!(repo instanceof FileRepository)) {
            return repo.newObjectInserter();
        }
        PackInserter ins = ((FileRepository)repo).getObjectDatabase().newPackInserter();
        ins.checkExisting(false);
        return ins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebuildProject(ReviewDb db, ImmutableListMultimap<Project.NameKey, Change.Id> allChanges, Project.NameKey project) {
        Preconditions.checkArgument(allChanges.containsKey(project));
        boolean ok = true;
        TextProgressMonitor pm = new TextProgressMonitor(new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.progressOut, StandardCharsets.UTF_8))));
        try (Repository changeRepo = this.repoManager.openRepository(project);
             ObjectInserter changeIns = NoteDbMigrator.newPackInserter(changeRepo);
             ObjectReader changeReader = changeIns.newReader();
             RevWalk changeRw = new RevWalk(changeReader);
             Repository allUsersRepo = this.repoManager.openRepository(this.allUsers);
             ObjectInserter allUsersIns = allUsersRepo.newObjectInserter();
             ObjectReader allUsersReader = allUsersIns.newReader();
             RevWalk allUsersRw = new RevWalk(allUsersReader);){
            ChainedReceiveCommands changeCmds = new ChainedReceiveCommands(changeRepo);
            ChainedReceiveCommands allUsersCmds = new ChainedReceiveCommands(allUsersRepo);
            ImmutableCollection changes = allChanges.get((Object)project);
            pm.beginTask(FormatUtil.elide("Rebuilding " + project.get(), 50), changes.size());
            int toSave = 0;
            try {
                for (Change.Id changeId : changes) {
                    ChainedReceiveCommands tmpChangeCmds = new ChainedReceiveCommands(changeCmds.getRepoRefCache());
                    ChainedReceiveCommands tmpAllUsersCmds = new ChainedReceiveCommands(allUsersCmds.getRepoRefCache());
                    try (NoteDbUpdateManager manager = this.updateManagerFactory.create(project).setAtomicRefUpdates(false).setSaveObjects(false).setChangeRepo(changeRepo, changeRw, changeIns, tmpChangeCmds).setAllUsersRepo(allUsersRepo, allUsersRw, allUsersIns, tmpAllUsersCmds);){
                        this.rebuild(db, changeId, manager);
                        manager.execute(true);
                        tmpChangeCmds.getCommands().values().forEach(c -> NoteDbMigrator.addCommand(changeCmds, c));
                        tmpAllUsersCmds.getCommands().values().forEach(c -> NoteDbMigrator.addCommand(allUsersCmds, c));
                        ++toSave;
                    }
                    catch (ChangeRebuilder.NoPatchSetsException e) {
                        log.warn(e.getMessage());
                    }
                    catch (ConflictingUpdateException ex) {
                        log.warn("Rebuilding detected a conflicting ReviewDb update for change {}; will be auto-rebuilt at runtime", (Object)changeId);
                    }
                    catch (Throwable t) {
                        log.error("Failed to rebuild change " + changeId, t);
                        ok = false;
                    }
                    pm.update(1);
                }
            }
            finally {
                pm.endTask();
            }
            pm.beginTask(FormatUtil.elide("Saving " + project.get(), 50), 0);
            try {
                this.save(changeRepo, changeRw, changeIns, changeCmds);
                this.save(allUsersRepo, allUsersRw, allUsersIns, allUsersCmds);
                pm.update(toSave);
            }
            catch (LockFailureException e) {
                log.warn("Rebuilding detected a conflicting NoteDb update for the following refs, which will be auto-rebuilt at runtime: {}", (Object)e.getFailedRefs().stream().distinct().sorted().collect(Collectors.joining(", ")));
            }
            catch (IOException e) {
                log.error("Failed to save NoteDb state for " + project, e);
            }
            finally {
                pm.endTask();
            }
        }
        catch (RepositoryNotFoundException e) {
            log.warn("Repository {} not found", (Object)project);
        }
        catch (IOException e) {
            log.error("Failed to rebuild project " + project, e);
        }
        return ok;
    }

    private void rebuild(ReviewDb db, Change.Id changeId, NoteDbUpdateManager manager) throws OrmException, IOException {
        Change change = ChangeRebuilderImpl.checkNoteDbState(ChangeNotes.readOneReviewDbChange(db, changeId));
        if (change == null) {
            throw new NoSuchChangeException(changeId);
        }
        this.rebuilder.buildUpdates(manager, this.bundleReader.fromReviewDb(db, changeId));
        this.rebuilder.execute(db, changeId, manager, true, false);
    }

    private static void addCommand(ChainedReceiveCommands cmds, ReceiveCommand cmd) {
        if (!cmd.getOldId().equals(cmd.getNewId())) {
            cmds.add(cmd);
        }
    }

    private void save(Repository repo, RevWalk rw, ObjectInserter ins, ChainedReceiveCommands cmds) throws IOException {
        if (cmds.isEmpty()) {
            return;
        }
        ins.flush();
        BatchRefUpdate bru = repo.getRefDatabase().newBatchUpdate();
        bru.setRefLogMessage("Migrate changes to NoteDb", false);
        bru.setRefLogIdent(this.serverIdent.get());
        bru.setAtomic(false);
        bru.setAllowNonFastForwards(true);
        cmds.addTo(bru);
        RefUpdateUtil.executeChecked(bru, rw);
    }

    private static boolean futuresToBoolean(List<ListenableFuture<Boolean>> futures, String errMsg) {
        try {
            return ((List)Futures.allAsList(futures).get()).stream().allMatch(b -> b);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(errMsg, e);
            return false;
        }
    }

    private class ContextHelper
    implements AutoCloseable {
        private final Thread callingThread = Thread.currentThread();
        private ReviewDb db;
        private Runnable closeDb;

        ContextHelper() {
        }

        ManualRequestContext open() throws OrmException {
            return new ManualRequestContext(NoteDbMigrator.this.userFactory.create(), (SchemaFactory<ReviewDb>)(Thread.currentThread().equals(this.callingThread) ? this::getReviewDb : NoteDbMigrator.this.schemaFactory), NoteDbMigrator.this.requestContext);
        }

        synchronized ReviewDb getReviewDb() throws OrmException {
            if (this.db == null) {
                ReviewDb actual = (ReviewDb)NoteDbMigrator.this.schemaFactory.open();
                this.closeDb = actual::close;
                this.db = new ReviewDbWrapper(ReviewDbUtil.unwrapDb(actual)){

                    @Override
                    public void close() {
                    }
                };
            }
            return this.db;
        }

        @Override
        public synchronized void close() {
            if (this.db != null) {
                this.closeDb.run();
                this.db = null;
                this.closeDb = null;
            }
        }
    }

    public static class Builder {
        private final Config cfg;
        private final SitePaths sitePaths;
        private final Provider<PersonIdent> serverIdent;
        private final AllUsersName allUsers;
        private final SchemaFactory<ReviewDb> schemaFactory;
        private final GitRepositoryManager repoManager;
        private final NoteDbUpdateManager.Factory updateManagerFactory;
        private final ChangeBundleReader bundleReader;
        private final AllProjectsName allProjects;
        private final InternalUser.Factory userFactory;
        private final ThreadLocalRequestContext requestContext;
        private final ChangeRebuilderImpl rebuilder;
        private final WorkQueue workQueue;
        private final MutableNotesMigration globalNotesMigration;
        private final PrimaryStorageMigrator primaryStorageMigrator;
        private final DynamicSet<NotesMigrationStateListener> listeners;
        private int threads;
        private ImmutableList<Project.NameKey> projects = ImmutableList.of();
        private ImmutableList<Change.Id> changes = ImmutableList.of();
        private OutputStream progressOut = NullOutputStream.INSTANCE;
        private NotesMigrationState stopAtState;
        private boolean trial;
        private boolean forceRebuild;
        private int sequenceGap = -1;
        private boolean autoMigrate;

        @Inject
        Builder(GerritServerConfigProvider configProvider, SitePaths sitePaths, @GerritPersonIdent Provider<PersonIdent> serverIdent, AllUsersName allUsers, SchemaFactory<ReviewDb> schemaFactory, GitRepositoryManager repoManager, NoteDbUpdateManager.Factory updateManagerFactory, ChangeBundleReader bundleReader, AllProjectsName allProjects, ThreadLocalRequestContext requestContext, InternalUser.Factory userFactory, ChangeRebuilderImpl rebuilder, WorkQueue workQueue, MutableNotesMigration globalNotesMigration, PrimaryStorageMigrator primaryStorageMigrator, DynamicSet<NotesMigrationStateListener> listeners) {
            this.cfg = configProvider.get();
            this.sitePaths = sitePaths;
            this.serverIdent = serverIdent;
            this.allUsers = allUsers;
            this.schemaFactory = schemaFactory;
            this.repoManager = repoManager;
            this.updateManagerFactory = updateManagerFactory;
            this.bundleReader = bundleReader;
            this.allProjects = allProjects;
            this.requestContext = requestContext;
            this.userFactory = userFactory;
            this.rebuilder = rebuilder;
            this.workQueue = workQueue;
            this.globalNotesMigration = globalNotesMigration;
            this.primaryStorageMigrator = primaryStorageMigrator;
            this.listeners = listeners;
            this.trial = NoteDbMigrator.getTrialMode(this.cfg);
            this.autoMigrate = NoteDbMigrator.getAutoMigrate(this.cfg);
        }

        public Builder setThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder setProjects(@Nullable Collection<Project.NameKey> projects) {
            this.projects = projects != null ? ImmutableList.copyOf(projects) : ImmutableList.of();
            return this;
        }

        public Builder setChanges(@Nullable Collection<Change.Id> changes) {
            this.changes = changes != null ? ImmutableList.copyOf(changes) : ImmutableList.of();
            return this;
        }

        public Builder setProgressOut(OutputStream progressOut) {
            this.progressOut = Preconditions.checkNotNull(progressOut);
            return this;
        }

        @VisibleForTesting
        public Builder setStopAtStateForTesting(NotesMigrationState stopAtState) {
            this.stopAtState = stopAtState;
            return this;
        }

        public Builder setTrialMode(boolean trial) {
            this.trial = trial;
            return this;
        }

        public Builder setForceRebuild(boolean forceRebuild) {
            this.forceRebuild = forceRebuild;
            return this;
        }

        public Builder setSequenceGap(int sequenceGap) {
            this.sequenceGap = sequenceGap;
            return this;
        }

        public Builder setAutoMigrate(boolean autoMigrate) {
            this.autoMigrate = autoMigrate;
            return this;
        }

        public NoteDbMigrator build() throws MigrationException {
            return new NoteDbMigrator(this.sitePaths, this.schemaFactory, this.serverIdent, this.allUsers, this.repoManager, this.updateManagerFactory, this.bundleReader, this.allProjects, this.requestContext, this.userFactory, this.rebuilder, this.globalNotesMigration, this.primaryStorageMigrator, this.listeners, this.threads > 1 ? MoreExecutors.listeningDecorator(this.workQueue.createQueue(this.threads, "RebuildChange", true)) : MoreExecutors.newDirectExecutorService(), this.projects, this.changes, this.progressOut, this.stopAtState, this.trial, this.forceRebuild, this.sequenceGap >= 0 ? this.sequenceGap : Sequences.getChangeSequenceGap(this.cfg), this.autoMigrate);
        }
    }
}

