/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.patch.AutoMerger;
import com.google.gerrit.server.patch.AutoValue_PatchListLoader_EditsDueToRebaseResult;
import com.google.gerrit.server.patch.ComparisonType;
import com.google.gerrit.server.patch.DiffExecutor;
import com.google.gerrit.server.patch.EditTransformer;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.Text;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchListLoader
implements Callable<PatchList> {
    static final Logger log = LoggerFactory.getLogger(PatchListLoader.class);
    private final GitRepositoryManager repoManager;
    private final PatchListCache patchListCache;
    private final ThreeWayMergeStrategy mergeStrategy;
    private final ExecutorService diffExecutor;
    private final AutoMerger autoMerger;
    private final PatchListKey key;
    private final Project.NameKey project;
    private final long timeoutMillis;
    private final boolean save;

    @Inject
    PatchListLoader(GitRepositoryManager mgr, PatchListCache plc, @GerritServerConfig Config cfg, @DiffExecutor ExecutorService de, AutoMerger am, @Assisted PatchListKey k, @Assisted Project.NameKey p) {
        this.repoManager = mgr;
        this.patchListCache = plc;
        this.mergeStrategy = MergeUtil.getMergeStrategy(cfg);
        this.diffExecutor = de;
        this.autoMerger = am;
        this.key = k;
        this.project = p;
        this.timeoutMillis = ConfigUtil.getTimeUnit(cfg, "cache", "diff", "timeout", TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS);
        this.save = AutoMerger.cacheAutomerge(cfg);
    }

    /*
     * Exception decompiling
     */
    @Override
    public PatchList call() throws IOException, PatchListNotAvailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RawTextComparator comparatorFor(DiffPreferencesInfo.Whitespace ws) {
        switch (ws) {
            case IGNORE_ALL: {
                return RawTextComparator.WS_IGNORE_ALL;
            }
            case IGNORE_TRAILING: {
                return RawTextComparator.WS_IGNORE_TRAILING;
            }
            case IGNORE_LEADING_AND_TRAILING: {
                return RawTextComparator.WS_IGNORE_CHANGE;
            }
        }
        return RawTextComparator.DEFAULT;
    }

    private ObjectInserter newInserter(Repository repo) {
        return this.save ? repo.newObjectInserter() : new InMemoryInserter(repo);
    }

    private PatchList readPatchList(Repository repo, RevWalk rw, ObjectInserter ins) throws IOException, PatchListNotAvailableException {
        ObjectReader reader = rw.getObjectReader();
        Preconditions.checkArgument(reader.getCreatedFromInserter() == ins);
        RawTextComparator cmp = PatchListLoader.comparatorFor(this.key.getWhitespace());
        try (DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);){
            boolean isMerge;
            RevCommit b = rw.parseCommit(this.key.getNewId());
            RevObject a = this.aFor(this.key, repo, rw, ins, b);
            if (a == null) {
                ComparisonType comparisonType = ComparisonType.againstParent(1);
                PatchListEntry[] entries = new PatchListEntry[]{this.newCommitMessage(cmp, reader, null, b), this.newMergeList(cmp, reader, null, b, comparisonType)};
                PatchList patchList = new PatchList(a, b, true, comparisonType, entries);
                return patchList;
            }
            ComparisonType comparisonType = this.getComparisonType(a, b);
            RevCommit aCommit = a instanceof RevCommit ? (RevCommit)a : null;
            RevTree aTree = rw.parseTree(a);
            RevTree bTree = b.getTree();
            df.setReader(reader, repo.getConfig());
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            List<DiffEntry> diffEntries = df.scan(aTree, bTree);
            ImmutableMultimap<String, EditTransformer.ContextAwareEdit> editsDueToRebasePerFilePath = ImmutableMultimap.of();
            EditsDueToRebaseResult editsDueToRebaseResult = this.determineEditsDueToRebase(aCommit, b, diffEntries, df, rw);
            diffEntries = editsDueToRebaseResult.getRelevantOriginalDiffEntries();
            editsDueToRebasePerFilePath = editsDueToRebaseResult.getEditsDueToRebasePerFilePath();
            ArrayList<PatchListEntry> entries = new ArrayList<PatchListEntry>();
            entries.add(this.newCommitMessage(cmp, reader, comparisonType.isAgainstParentOrAutoMerge() ? null : aCommit, b));
            boolean bl = isMerge = b.getParentCount() > 1;
            if (isMerge) {
                entries.add(this.newMergeList(cmp, reader, comparisonType.isAgainstParentOrAutoMerge() ? null : aCommit, b, comparisonType));
            }
            for (DiffEntry diffEntry : diffEntries) {
                Set<EditTransformer.ContextAwareEdit> editsDueToRebase = PatchListLoader.getEditsDueToRebase(editsDueToRebasePerFilePath, diffEntry);
                Optional<PatchListEntry> patchListEntry = this.getPatchListEntry(reader, df, diffEntry, aTree, bTree, editsDueToRebase);
                patchListEntry.ifPresent(entries::add);
            }
            PatchList patchList = new PatchList(a, b, isMerge, comparisonType, entries.toArray(new PatchListEntry[entries.size()]));
            return patchList;
        }
    }

    private EditsDueToRebaseResult determineEditsDueToRebase(RevCommit commitA, RevCommit commitB, List<DiffEntry> diffEntries, DiffFormatter df, RevWalk rw) throws PatchListNotAvailableException, IOException {
        if (commitA == null || PatchListLoader.isRootOrMergeCommit(commitA) || PatchListLoader.isRootOrMergeCommit(commitB) || PatchListLoader.areParentChild(commitA, commitB) || PatchListLoader.haveCommonParent(commitA, commitB)) {
            return EditsDueToRebaseResult.create(diffEntries, ImmutableMultimap.of());
        }
        PatchListKey oldKey = PatchListKey.againstDefaultBase(this.key.getOldId(), this.key.getWhitespace());
        PatchList oldPatchList = this.patchListCache.get(oldKey, this.project);
        PatchListKey newKey = PatchListKey.againstDefaultBase(this.key.getNewId(), this.key.getWhitespace());
        PatchList newPatchList = this.patchListCache.get(newKey, this.project);
        List<PatchListEntry> oldPatches = oldPatchList.getPatches();
        List<PatchListEntry> newPatches = newPatchList.getPatches();
        HashSet<String> touchedFilePaths = new HashSet<String>();
        for (PatchListEntry patchListEntry : oldPatches) {
            touchedFilePaths.addAll(PatchListLoader.getTouchedFilePaths(patchListEntry));
        }
        for (PatchListEntry patchListEntry : newPatches) {
            touchedFilePaths.addAll(PatchListLoader.getTouchedFilePaths(patchListEntry));
        }
        List relevantDiffEntries = diffEntries.stream().filter(diffEntry -> PatchListLoader.isTouched(touchedFilePaths, diffEntry)).collect(ImmutableList.toImmutableList());
        RevCommit parentCommitA = commitA.getParent(0);
        rw.parseBody(parentCommitA);
        RevCommit parentCommitB = commitB.getParent(0);
        rw.parseBody(parentCommitB);
        List<DiffEntry> parentDiffEntries = df.scan(parentCommitA, parentCommitB);
        List<PatchListEntry> parentPatchListEntries = this.getRelevantPatchListEntries(parentDiffEntries, parentCommitA, parentCommitB, touchedFilePaths, df);
        EditTransformer editTransformer = new EditTransformer(parentPatchListEntries);
        editTransformer.transformReferencesOfSideA(oldPatches);
        editTransformer.transformReferencesOfSideB(newPatches);
        return EditsDueToRebaseResult.create(relevantDiffEntries, editTransformer.getEditsPerFilePath());
    }

    private static boolean isRootOrMergeCommit(RevCommit commit) {
        return commit.getParentCount() != 1;
    }

    private static boolean areParentChild(RevCommit commitA, RevCommit commitB) {
        return ObjectId.equals(commitA.getParent(0), commitB) || ObjectId.equals(commitB.getParent(0), commitA);
    }

    private static boolean haveCommonParent(RevCommit commitA, RevCommit commitB) {
        return ObjectId.equals(commitA.getParent(0), commitB.getParent(0));
    }

    private static Set<String> getTouchedFilePaths(PatchListEntry patchListEntry) {
        String oldFilePath = patchListEntry.getOldName();
        String newFilePath = patchListEntry.getNewName();
        return oldFilePath == null ? ImmutableSet.of(newFilePath) : ImmutableSet.of(oldFilePath, newFilePath);
    }

    private static boolean isTouched(Set<String> touchedFilePaths, DiffEntry diffEntry) {
        String oldFilePath = diffEntry.getOldPath();
        String newFilePath = diffEntry.getNewPath();
        return touchedFilePaths.contains(oldFilePath) || touchedFilePaths.contains(newFilePath);
    }

    private List<PatchListEntry> getRelevantPatchListEntries(List<DiffEntry> parentDiffEntries, RevCommit parentCommitA, RevCommit parentCommitB, Set<String> touchedFilePaths, DiffFormatter diffFormatter) throws IOException {
        ArrayList<PatchListEntry> parentPatchListEntries = new ArrayList<PatchListEntry>(parentDiffEntries.size());
        for (DiffEntry parentDiffEntry : parentDiffEntries) {
            if (!PatchListLoader.isTouched(touchedFilePaths, parentDiffEntry)) continue;
            FileHeader fileHeader = this.toFileHeader(parentCommitB, diffFormatter, parentDiffEntry);
            PatchListEntry patchListEntry = PatchListLoader.newEntry(parentCommitA.getTree(), fileHeader, ImmutableSet.of(), 0L, 0L);
            parentPatchListEntries.add(patchListEntry);
        }
        return parentPatchListEntries;
    }

    private static Set<EditTransformer.ContextAwareEdit> getEditsDueToRebase(Multimap<String, EditTransformer.ContextAwareEdit> editsDueToRebasePerFilePath, DiffEntry diffEntry) {
        if (editsDueToRebasePerFilePath.isEmpty()) {
            return ImmutableSet.of();
        }
        String filePath = diffEntry.getNewPath();
        if (diffEntry.getChangeType() == DiffEntry.ChangeType.DELETE) {
            filePath = diffEntry.getOldPath();
        }
        return ImmutableSet.copyOf(editsDueToRebasePerFilePath.get(filePath));
    }

    private Optional<PatchListEntry> getPatchListEntry(ObjectReader objectReader, DiffFormatter diffFormatter, DiffEntry diffEntry, RevTree treeA, RevTree treeB, Set<EditTransformer.ContextAwareEdit> editsDueToRebase) throws IOException {
        FileHeader fileHeader = this.toFileHeader(this.key.getNewId(), diffFormatter, diffEntry);
        long oldSize = PatchListLoader.getFileSize(objectReader, diffEntry.getOldMode(), diffEntry.getOldPath(), treeA);
        long newSize = PatchListLoader.getFileSize(objectReader, diffEntry.getNewMode(), diffEntry.getNewPath(), treeB);
        Set<Edit> contentEditsDueToRebase = PatchListLoader.getContentEdits(editsDueToRebase);
        PatchListEntry patchListEntry = PatchListLoader.newEntry(treeA, fileHeader, contentEditsDueToRebase, newSize, newSize - oldSize);
        if (EditTransformer.toEdits(patchListEntry).allMatch(editsDueToRebase::contains)) {
            return Optional.empty();
        }
        return Optional.of(patchListEntry);
    }

    private static Set<Edit> getContentEdits(Set<EditTransformer.ContextAwareEdit> editsDueToRebase) {
        return editsDueToRebase.stream().map(EditTransformer.ContextAwareEdit::toEdit).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private ComparisonType getComparisonType(RevObject a, RevCommit b) {
        for (int i = 0; i < b.getParentCount(); ++i) {
            if (!b.getParent(i).equals(a)) continue;
            return ComparisonType.againstParent(i + 1);
        }
        if (this.key.getOldId() == null && b.getParentCount() > 0) {
            return ComparisonType.againstAutoMerge();
        }
        return ComparisonType.againstOtherPatchSet();
    }

    private static long getFileSize(ObjectReader reader, FileMode mode, String path, RevTree t) throws IOException {
        if (!PatchListLoader.isBlob(mode)) {
            return 0L;
        }
        try (TreeWalk tw = TreeWalk.forPath(reader, path, t);){
            long l = tw != null ? reader.open(tw.getObjectId(0), 3).getSize() : 0L;
            return l;
        }
    }

    private static boolean isBlob(FileMode mode) {
        int t = mode.getBits() & 0xF000;
        return t == 32768 || t == 40960;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileHeader toFileHeader(ObjectId commitB, DiffFormatter diffFormatter, DiffEntry diffEntry) throws IOException {
        Future<FileHeader> result = this.diffExecutor.submit(() -> {
            DiffEntry diffEntry2 = diffEntry;
            synchronized (diffEntry2) {
                return diffFormatter.toFileHeader(diffEntry);
            }
        });
        try {
            return result.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            log.warn(this.timeoutMillis + " ms timeout reached for Diff loader in project " + this.project + " on commit " + commitB.name() + " on path " + diffEntry.getNewPath() + " comparing " + diffEntry.getOldId().name() + ".." + diffEntry.getNewId().name());
            result.cancel(true);
            DiffEntry diffEntry2 = diffEntry;
            synchronized (diffEntry2) {
                return this.toFileHeaderWithoutMyersDiff(diffFormatter, diffEntry);
            }
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), IOException.class);
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    private FileHeader toFileHeaderWithoutMyersDiff(DiffFormatter diffFormatter, DiffEntry diffEntry) throws IOException {
        HistogramDiff histogramDiff = new HistogramDiff();
        histogramDiff.setFallbackAlgorithm(null);
        diffFormatter.setDiffAlgorithm(histogramDiff);
        return diffFormatter.toFileHeader(diffEntry);
    }

    private PatchListEntry newCommitMessage(RawTextComparator cmp, ObjectReader reader, RevCommit aCommit, RevCommit bCommit) throws IOException {
        Text aText = aCommit != null ? Text.forCommit(reader, aCommit) : Text.EMPTY;
        Text bText = Text.forCommit(reader, bCommit);
        return PatchListLoader.createPatchListEntry(cmp, aCommit, aText, bText, "/COMMIT_MSG");
    }

    private PatchListEntry newMergeList(RawTextComparator cmp, ObjectReader reader, RevCommit aCommit, RevCommit bCommit, ComparisonType comparisonType) throws IOException {
        Text aText = aCommit != null ? Text.forMergeList(comparisonType, reader, aCommit) : Text.EMPTY;
        Text bText = Text.forMergeList(comparisonType, reader, bCommit);
        return PatchListLoader.createPatchListEntry(cmp, aCommit, aText, bText, "/MERGE_LIST");
    }

    private static PatchListEntry createPatchListEntry(RawTextComparator cmp, RevCommit aCommit, Text aText, Text bText, String fileName) {
        byte[] rawHdr = PatchListLoader.getRawHeader(aCommit != null, fileName);
        byte[] aContent = aText.getContent();
        byte[] bContent = bText.getContent();
        long size = bContent.length;
        long sizeDelta = bContent.length - aContent.length;
        RawText aRawText = new RawText(aContent);
        RawText bRawText = new RawText(bContent);
        EditList edits = new HistogramDiff().diff(cmp, aRawText, bRawText);
        FileHeader fh = new FileHeader(rawHdr, edits, FileHeader.PatchType.UNIFIED);
        return new PatchListEntry(fh, edits, ImmutableSet.of(), size, sizeDelta);
    }

    private static byte[] getRawHeader(boolean hasA, String fileName) {
        StringBuilder hdr = new StringBuilder();
        hdr.append("diff --git");
        if (hasA) {
            hdr.append(" a/").append(fileName);
        } else {
            hdr.append(" ").append("/dev/null");
        }
        hdr.append(" b/").append(fileName);
        hdr.append("\n");
        if (hasA) {
            hdr.append("--- a/").append(fileName).append("\n");
        } else {
            hdr.append("--- ").append("/dev/null").append("\n");
        }
        hdr.append("+++ b/").append(fileName).append("\n");
        return hdr.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static PatchListEntry newEntry(RevTree aTree, FileHeader fileHeader, Set<Edit> editsDueToRebase, long size, long sizeDelta) {
        if (aTree == null || fileHeader.getPatchType() != FileHeader.PatchType.UNIFIED || fileHeader.getHunks().isEmpty()) {
            return new PatchListEntry(fileHeader, ImmutableList.of(), ImmutableSet.of(), size, sizeDelta);
        }
        EditList edits = fileHeader.toEditList();
        if (edits.isEmpty()) {
            return new PatchListEntry(fileHeader, ImmutableList.of(), ImmutableSet.of(), size, sizeDelta);
        }
        return new PatchListEntry(fileHeader, edits, editsDueToRebase, size, sizeDelta);
    }

    private RevObject aFor(PatchListKey key, Repository repo, RevWalk rw, ObjectInserter ins, RevCommit b) throws IOException {
        if (key.getOldId() != null) {
            return rw.parseAny(key.getOldId());
        }
        switch (b.getParentCount()) {
            case 0: {
                return rw.parseAny(PatchListLoader.emptyTree(ins));
            }
            case 1: {
                RevCommit r = b.getParent(0);
                rw.parseBody(r);
                return r;
            }
            case 2: {
                if (key.getParentNum() != null) {
                    RevCommit r = b.getParent(key.getParentNum() - 1);
                    rw.parseBody(r);
                    return r;
                }
                return this.autoMerger.merge(repo, rw, ins, b, this.mergeStrategy);
            }
        }
        return null;
    }

    private static ObjectId emptyTree(ObjectInserter ins) throws IOException {
        ObjectId id = ins.insert(2, new byte[0]);
        ins.flush();
        return id;
    }

    @AutoValue
    static abstract class EditsDueToRebaseResult {
        EditsDueToRebaseResult() {
        }

        public static EditsDueToRebaseResult create(List<DiffEntry> relevantDiffEntries, Multimap<String, EditTransformer.ContextAwareEdit> editsDueToRebasePerFilePath) {
            return new AutoValue_PatchListLoader_EditsDueToRebaseResult(relevantDiffEntries, editsDueToRebasePerFilePath);
        }

        public abstract List<DiffEntry> getRelevantOriginalDiffEntries();

        public abstract Multimap<String, EditTransformer.ContextAwareEdit> getEditsDueToRebasePerFilePath();
    }

    public static interface Factory {
        public PatchListLoader create(PatchListKey var1, Project.NameKey var2);
    }
}

