/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.CapabilityScope;
import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.api.access.PluginPermission;
import com.google.gerrit.server.permissions.PermissionBackendException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GlobalPermission implements GlobalOrPluginPermission
{
    ACCESS_DATABASE("accessDatabase"),
    ADMINISTRATE_SERVER("administrateServer"),
    CREATE_ACCOUNT("createAccount"),
    CREATE_GROUP("createGroup"),
    CREATE_PROJECT("createProject"),
    EMAIL_REVIEWERS("emailReviewers"),
    FLUSH_CACHES("flushCaches"),
    KILL_TASK("killTask"),
    MAINTAIN_SERVER("maintainServer"),
    MODIFY_ACCOUNT("modifyAccount"),
    RUN_AS("runAs"),
    RUN_GC("runGC"),
    STREAM_EVENTS("streamEvents"),
    VIEW_ALL_ACCOUNTS("viewAllAccounts"),
    VIEW_CACHES("viewCaches"),
    VIEW_CONNECTIONS("viewConnections"),
    VIEW_PLUGINS("viewPlugins"),
    VIEW_QUEUE("viewQueue");

    private static final Logger log;
    private static final ImmutableMap<String, GlobalPermission> BY_NAME;
    private final String name;

    @Nullable
    public static GlobalPermission byName(String name) {
        return BY_NAME.get(name);
    }

    public static Set<GlobalOrPluginPermission> fromAnnotation(@Nullable String pluginName, Class<?> clazz) throws PermissionBackendException {
        RequiresCapability rc = GlobalPermission.findAnnotation(clazz, RequiresCapability.class);
        RequiresAnyCapability rac = GlobalPermission.findAnnotation(clazz, RequiresAnyCapability.class);
        if (rc != null && rac != null) {
            log.error("Class {} uses both @{} and @{}", clazz.getName(), RequiresCapability.class.getSimpleName(), RequiresAnyCapability.class.getSimpleName());
            throw new PermissionBackendException("cannot extract permission");
        }
        if (rc != null) {
            return Collections.singleton(GlobalPermission.resolve(pluginName, rc.value(), rc.scope(), rc.fallBackToAdmin(), clazz, RequiresCapability.class));
        }
        if (rac != null) {
            LinkedHashSet<GlobalOrPluginPermission> r = new LinkedHashSet<GlobalOrPluginPermission>();
            for (String capability : rac.value()) {
                r.add(GlobalPermission.resolve(pluginName, capability, rac.scope(), rac.fallBackToAdmin(), clazz, RequiresAnyCapability.class));
            }
            return Collections.unmodifiableSet(r);
        }
        return Collections.emptySet();
    }

    public static Set<GlobalOrPluginPermission> fromAnnotation(Class<?> clazz) throws PermissionBackendException {
        return GlobalPermission.fromAnnotation(null, clazz);
    }

    private GlobalPermission(String name) {
        this.name = name;
    }

    @Override
    public String permissionName() {
        return this.name;
    }

    @Override
    public String describeForException() {
        return this.toString().toLowerCase(Locale.US).replace('_', ' ');
    }

    private static GlobalOrPluginPermission resolve(@Nullable String pluginName, String capability, CapabilityScope scope, boolean fallBackToAdmin, Class<?> clazz, Class<?> annotationClass) throws PermissionBackendException {
        if (!(pluginName == null || "gerrit".equals(pluginName) || scope != CapabilityScope.PLUGIN && scope != CapabilityScope.CONTEXT)) {
            return new PluginPermission(pluginName, capability, fallBackToAdmin);
        }
        if (scope == CapabilityScope.PLUGIN) {
            log.error("Class {} uses @{}(scope={}), but is not within a plugin", clazz.getName(), annotationClass.getSimpleName(), scope.name());
            throw new PermissionBackendException("cannot extract permission");
        }
        GlobalPermission perm = GlobalPermission.byName(capability);
        if (perm == null) {
            log.error("Class {} requires unknown capability {}", (Object)clazz.getName(), (Object)capability);
            throw new PermissionBackendException("cannot extract permission");
        }
        return perm;
    }

    @Nullable
    private static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotation) {
        while (clazz != null) {
            T t = clazz.getAnnotation(annotation);
            if (t != null) {
                return t;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(GlobalPermission.class);
        ImmutableMap.Builder<String, GlobalPermission> m = ImmutableMap.builder();
        for (GlobalPermission p : GlobalPermission.values()) {
            m.put(p.permissionName(), p);
        }
        BY_NAME = m.build();
    }
}

