/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefValidationHelper;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRef {
    private static final Logger log = LoggerFactory.getLogger(DeleteRef.class);
    private static final int MAX_LOCK_FAILURE_CALLS = 10;
    private static final long SLEEP_ON_LOCK_FAILURE_MS = 15L;
    private final Provider<IdentifiedUser> identifiedUser;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated referenceUpdated;
    private final RefValidationHelper refDeletionValidator;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ProjectResource resource;
    private final List<String> refsToDelete;
    private String prefix;

    @Inject
    DeleteRef(Provider<IdentifiedUser> identifiedUser, PermissionBackend permissionBackend, GitRepositoryManager repoManager, GitReferenceUpdated referenceUpdated, RefValidationHelper.Factory refDeletionValidatorFactory, Provider<InternalChangeQuery> queryProvider, @Assisted ProjectResource resource) {
        this.identifiedUser = identifiedUser;
        this.permissionBackend = permissionBackend;
        this.repoManager = repoManager;
        this.referenceUpdated = referenceUpdated;
        this.refDeletionValidator = refDeletionValidatorFactory.create(ReceiveCommand.Type.DELETE);
        this.queryProvider = queryProvider;
        this.resource = resource;
        this.refsToDelete = new ArrayList<String>();
    }

    public DeleteRef ref(String ref) {
        this.refsToDelete.add(ref);
        return this;
    }

    public DeleteRef refs(List<String> refs) {
        this.refsToDelete.addAll(refs);
        return this;
    }

    public DeleteRef prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public void delete() throws OrmException, IOException, ResourceConflictException, AuthException, PermissionBackendException {
        if (!this.refsToDelete.isEmpty()) {
            try (Repository r = this.repoManager.openRepository(this.resource.getNameKey());){
                if (this.refsToDelete.size() == 1) {
                    this.deleteSingleRef(r);
                } else {
                    this.deleteMultipleRefs(r);
                }
            }
        }
    }

    private void deleteSingleRef(Repository r) throws IOException, ResourceConflictException, AuthException, PermissionBackendException {
        RefUpdate.Result result;
        String ref = this.refsToDelete.get(0);
        if (this.prefix != null && !ref.startsWith("refs/")) {
            ref = this.prefix + ref;
        }
        this.permissionBackend.user(this.identifiedUser).project(this.resource.getNameKey()).ref(ref).check(RefPermission.DELETE);
        RefUpdate u = r.updateRef(ref);
        u.setExpectedOldObjectId(r.exactRef(ref).getObjectId());
        u.setNewObjectId(ObjectId.zeroId());
        u.setForceUpdate(true);
        this.refDeletionValidator.validateRefOperation(this.resource.getName(), this.identifiedUser.get(), u);
        int remainingLockFailureCalls = 10;
        while (true) {
            try {
                result = u.delete();
            }
            catch (LockFailedException e) {
                result = RefUpdate.Result.LOCK_FAILURE;
            }
            catch (IOException e) {
                log.error("Cannot delete " + ref, e);
                throw e;
            }
            if (result != RefUpdate.Result.LOCK_FAILURE || --remainingLockFailureCalls <= 0) break;
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {}
        }
        switch (result) {
            case NEW: 
            case NO_CHANGE: 
            case FAST_FORWARD: 
            case FORCED: {
                this.referenceUpdated.fire(this.resource.getNameKey(), u, ReceiveCommand.Type.DELETE, this.identifiedUser.get().getAccount());
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                log.error("Cannot delete " + ref + ": " + result.name());
                throw new ResourceConflictException("cannot delete current branch");
            }
            default: {
                log.error("Cannot delete " + ref + ": " + result.name());
                throw new ResourceConflictException("cannot delete: " + result.name());
            }
        }
    }

    private void deleteMultipleRefs(Repository r) throws OrmException, IOException, ResourceConflictException, PermissionBackendException {
        BatchRefUpdate batchUpdate = r.getRefDatabase().newBatchUpdate();
        batchUpdate.setAtomic(false);
        List<String> refs = this.prefix == null ? this.refsToDelete : this.refsToDelete.stream().map(ref -> ref.startsWith("refs/") ? ref : this.prefix + ref).collect(Collectors.toList());
        for (String ref2 : refs) {
            batchUpdate.addCommand(this.createDeleteCommand(this.resource, r, ref2));
        }
        RevWalk rw = new RevWalk(r);
        Object object = null;
        try {
            batchUpdate.execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            DeleteRef.$closeResource((Throwable)object, rw);
        }
        StringBuilder errorMessages = new StringBuilder();
        for (ReceiveCommand command : batchUpdate.getCommands()) {
            if (command.getResult() == ReceiveCommand.Result.OK) {
                this.postDeletion(this.resource, command);
                continue;
            }
            this.appendAndLogErrorMessage(errorMessages, command);
        }
        if (errorMessages.length() > 0) {
            throw new ResourceConflictException(errorMessages.toString());
        }
    }

    private ReceiveCommand createDeleteCommand(ProjectResource project, Repository r, String refName) throws OrmException, IOException, ResourceConflictException, PermissionBackendException {
        Ref ref = r.getRefDatabase().getRef(refName);
        if (ref == null) {
            ReceiveCommand command = new ReceiveCommand(ObjectId.zeroId(), ObjectId.zeroId(), refName);
            command.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "it doesn't exist or you do not have permission to delete it");
            return command;
        }
        ReceiveCommand command = new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), ref.getName());
        try {
            this.permissionBackend.user(this.identifiedUser).project(project.getNameKey()).ref(refName).check(RefPermission.DELETE);
        }
        catch (AuthException denied) {
            command.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "it doesn't exist or you do not have permission to delete it");
        }
        if (!refName.startsWith("refs/tags/")) {
            Branch.NameKey branchKey = new Branch.NameKey(project.getNameKey(), ref.getName());
            if (!this.queryProvider.get().setLimit(1).byBranchOpen(branchKey).isEmpty()) {
                command.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "it has open changes");
            }
        }
        RefUpdate u = r.updateRef(refName);
        u.setForceUpdate(true);
        u.setExpectedOldObjectId(r.exactRef(refName).getObjectId());
        u.setNewObjectId(ObjectId.zeroId());
        this.refDeletionValidator.validateRefOperation(project.getName(), this.identifiedUser.get(), u);
        return command;
    }

    private void appendAndLogErrorMessage(StringBuilder errorMessages, ReceiveCommand cmd) {
        String msg = null;
        switch (cmd.getResult()) {
            case REJECTED_CURRENT_BRANCH: {
                msg = String.format("Cannot delete %s: it is the current branch", cmd.getRefName());
                break;
            }
            case REJECTED_OTHER_REASON: {
                msg = String.format("Cannot delete %s: %s", cmd.getRefName(), cmd.getMessage());
                break;
            }
            default: {
                msg = String.format("Cannot delete %s: %s", new Object[]{cmd.getRefName(), cmd.getResult()});
            }
        }
        log.error(msg);
        errorMessages.append(msg);
        errorMessages.append("\n");
    }

    private void postDeletion(ProjectResource project, ReceiveCommand cmd) {
        this.referenceUpdated.fire(project.getNameKey(), cmd, this.identifiedUser.get().getAccount());
    }

    public static interface Factory {
        public DeleteRef create(ProjectResource var1);
    }
}

