/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefFilter;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;

public class ListBranches
implements RestReadView<ProjectResource> {
    private final GitRepositoryManager repoManager;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final DynamicMap<RestView<BranchResource>> branchViews;
    private final UiActions uiActions;
    private final WebLinks webLinks;
    private int limit;
    private int start;
    private String matchSubstring;
    private String matchRegex;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of branches to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S", "-s"}, metaVar="CNT", usage="number of branches to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match branches substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="--regex", aliases={"-r"}, metaVar="REGEX", usage="match branches regex")
    public void setMatchRegex(String matchRegex) {
        this.matchRegex = matchRegex;
    }

    @Inject
    public ListBranches(GitRepositoryManager repoManager, PermissionBackend permissionBackend, Provider<CurrentUser> user, DynamicMap<RestView<BranchResource>> branchViews, UiActions uiActions, WebLinks webLinks) {
        this.repoManager = repoManager;
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.branchViews = branchViews;
        this.uiActions = uiActions;
        this.webLinks = webLinks;
    }

    public ListBranches request(ProjectApi.ListRefsRequest<BranchInfo> request) {
        this.setLimit(request.getLimit());
        this.setStart(request.getStart());
        this.setMatchSubstring(request.getSubstring());
        this.setMatchRegex(request.getRegex());
        return this;
    }

    public List<BranchInfo> apply(ProjectResource rsrc) throws ResourceNotFoundException, IOException, BadRequestException, PermissionBackendException {
        return new RefFilter("refs/heads/").subString(this.matchSubstring).regex(this.matchRegex).start(this.start).limit(this.limit).filter(this.allBranches(rsrc));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BranchInfo toBranchInfo(BranchResource rsrc) throws IOException, ResourceNotFoundException, PermissionBackendException {
        try (Repository db = this.repoManager.openRepository(rsrc.getNameKey());){
            Ref r = db.exactRef(rsrc.getRef());
            if (r == null) {
                throw new ResourceNotFoundException();
            }
            BranchInfo branchInfo = this.toBranchInfo(rsrc, ImmutableList.of(r)).get(0);
            return branchInfo;
        }
        catch (RepositoryNotFoundException noRepo) {
            throw new ResourceNotFoundException();
        }
    }

    private List<BranchInfo> allBranches(ProjectResource rsrc) throws IOException, ResourceNotFoundException, PermissionBackendException {
        ArrayList<Ref> refs;
        try (Repository db = this.repoManager.openRepository(rsrc.getNameKey());){
            Collection<Ref> heads = db.getRefDatabase().getRefs("refs/heads/").values();
            refs = new ArrayList<Ref>(heads.size() + 3);
            refs.addAll(heads);
            refs.addAll(db.getRefDatabase().exactRef("HEAD", "refs/meta/config", "refs/users/default").values());
        }
        catch (RepositoryNotFoundException noGitRepository) {
            throw new ResourceNotFoundException();
        }
        return this.toBranchInfo(rsrc, refs);
    }

    private List<BranchInfo> toBranchInfo(ProjectResource rsrc, List<Ref> refs) throws PermissionBackendException {
        HashSet<String> targets = Sets.newHashSetWithExpectedSize(1);
        for (Ref ref : refs) {
            if (!ref.isSymbolic()) continue;
            targets.add(ref.getTarget().getName());
        }
        ProjectControl pctl = rsrc.getControl();
        PermissionBackend.ForProject perm = this.permissionBackend.user(this.user).project(rsrc.getNameKey());
        ArrayList<BranchInfo> branches = new ArrayList<BranchInfo>(refs.size());
        for (Ref ref : refs) {
            if (ref.isSymbolic()) {
                String target = ref.getTarget().getName();
                if (!perm.ref(target).test(RefPermission.READ)) continue;
                if (target.startsWith("refs/heads/")) {
                    target = target.substring("refs/heads/".length());
                }
                BranchInfo b = new BranchInfo();
                b.ref = ref.getName();
                b.revision = target;
                branches.add(b);
                if ("HEAD".equals(ref.getName())) continue;
                b.canDelete = perm.ref(ref.getName()).testOrFalse(RefPermission.DELETE) ? Boolean.valueOf(true) : null;
                continue;
            }
            if (!perm.ref(ref.getName()).test(RefPermission.READ)) continue;
            branches.add(this.createBranchInfo(perm.ref(ref.getName()), ref, pctl, targets));
        }
        Collections.sort(branches, new BranchComparator());
        return branches;
    }

    private BranchInfo createBranchInfo(PermissionBackend.ForRef perm, Ref ref, ProjectControl pctl, Set<String> targets) {
        BranchInfo info = new BranchInfo();
        info.ref = ref.getName();
        info.revision = ref.getObjectId() != null ? ref.getObjectId().name() : null;
        info.canDelete = !targets.contains(ref.getName()) && perm.testOrFalse(RefPermission.DELETE) ? Boolean.valueOf(true) : null;
        BranchResource rsrc = new BranchResource(pctl, ref);
        for (UiAction.Description d : this.uiActions.from(this.branchViews, rsrc)) {
            if (info.actions == null) {
                info.actions = new TreeMap<String, ActionInfo>();
            }
            info.actions.put(d.getId(), new ActionInfo(d));
        }
        List<WebLinkInfo> links = this.webLinks.getBranchLinks(pctl.getProject().getName(), ref.getName());
        info.webLinks = links.isEmpty() ? null : links;
        return info;
    }

    private static class BranchComparator
    implements Comparator<BranchInfo> {
        private BranchComparator() {
        }

        @Override
        public int compare(BranchInfo a, BranchInfo b) {
            return ComparisonChain.start().compareTrueFirst(BranchComparator.isHead(a), BranchComparator.isHead(b)).compareTrueFirst(BranchComparator.isConfig(a), BranchComparator.isConfig(b)).compare((Comparable<?>)((Object)a.ref), (Comparable<?>)((Object)b.ref)).result();
        }

        private static boolean isHead(BranchInfo i) {
            return "HEAD".equals(i.ref);
        }

        private static boolean isConfig(BranchInfo i) {
            return "refs/meta/config".equals(i.ref);
        }
    }
}

