/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.account;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.query.AndSource;
import com.google.gerrit.index.query.IndexPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryProcessor;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.index.account.AccountIndexCollection;
import com.google.gerrit.server.index.account.AccountIndexRewriter;
import com.google.gerrit.server.index.account.AccountSchemaDefinitions;
import com.google.gerrit.server.query.account.AccountIsVisibleToPredicate;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class AccountQueryProcessor
extends QueryProcessor<AccountState> {
    private final AccountControl.Factory accountControlFactory;

    @Inject
    protected AccountQueryProcessor(Provider<CurrentUser> userProvider, AccountLimits.Factory limitsFactory, MetricMaker metricMaker, IndexConfig indexConfig, AccountIndexCollection indexes, AccountIndexRewriter rewriter, AccountControl.Factory accountControlFactory) {
        super(metricMaker, AccountSchemaDefinitions.INSTANCE, indexConfig, indexes, rewriter, "limit", () -> limitsFactory.create((CurrentUser)userProvider.get()).getQueryLimit());
        this.accountControlFactory = accountControlFactory;
    }

    @Override
    protected Predicate<AccountState> enforceVisibility(Predicate<AccountState> pred) {
        return new AndSource<AccountState>(pred, new AccountIsVisibleToPredicate(this.accountControlFactory.get()), this.start);
    }

    static {
        Preconditions.checkState(!AccountIsVisibleToPredicate.class.isAssignableFrom(IndexPredicate.class), "AccountQueryProcessor assumes visibleto is not used by the index rewriter.");
    }
}

