/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public final class ChangeStatusPredicate
extends ChangeIndexPredicate {
    private static final String INVALID_STATUS = "__invalid__";
    private static final Predicate<ChangeData> NONE = new ChangeStatusPredicate(null);
    private static final TreeMap<String, Predicate<ChangeData>> PREDICATES = new TreeMap();
    private static final Predicate<ChangeData> CLOSED;
    private static final Predicate<ChangeData> OPEN;
    @Nullable
    private final Change.Status status;

    public static String canonicalize(Change.Status status) {
        return status.name().toLowerCase();
    }

    public static Predicate<ChangeData> parse(String value) {
        Map.Entry e;
        String lower = value.toLowerCase();
        NavigableMap<String, Predicate<ChangeData>> head = PREDICATES.tailMap(lower, true);
        if (!head.isEmpty() && ((String)(e = head.entrySet().iterator().next()).getKey()).startsWith(lower)) {
            return (Predicate)e.getValue();
        }
        return NONE;
    }

    public static Predicate<ChangeData> open() {
        return OPEN;
    }

    public static Predicate<ChangeData> closed() {
        return CLOSED;
    }

    public static ChangeStatusPredicate forStatus(Change.Status status) {
        return new ChangeStatusPredicate(Preconditions.checkNotNull(status));
    }

    private ChangeStatusPredicate(@Nullable Change.Status status) {
        super(ChangeField.STATUS, status != null ? ChangeStatusPredicate.canonicalize(status) : INVALID_STATUS);
        this.status = status;
    }

    @Nullable
    public Change.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        return change != null && Objects.equals((Object)this.status, (Object)change.getStatus());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object)this.status);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ChangeStatusPredicate && Objects.equals((Object)this.status, (Object)((ChangeStatusPredicate)other).status);
    }

    @Override
    public String toString() {
        return this.getOperator() + ":" + this.getValue();
    }

    static {
        ArrayList<ChangeStatusPredicate> open = new ArrayList<ChangeStatusPredicate>();
        ArrayList closed = new ArrayList();
        for (Change.Status s : Change.Status.values()) {
            ChangeStatusPredicate p = ChangeStatusPredicate.forStatus(s);
            String str = ChangeStatusPredicate.canonicalize(s);
            Preconditions.checkState(!INVALID_STATUS.equals(str), "invalid status sentinel %s cannot match canonicalized status string %s", (Object)INVALID_STATUS, (Object)str);
            PREDICATES.put(str, p);
            (s.isOpen() ? open : closed).add(p);
        }
        CLOSED = Predicate.or(closed);
        OPEN = Predicate.or(open);
        PREDICATES.put("closed", CLOSED);
        PREDICATES.put("open", OPEN);
        PREDICATES.put("pending", OPEN);
    }
}

