/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gwtorm.server.OrmException;

public class CommentPredicate
extends ChangeIndexPredicate {
    protected final ChangeIndex index;

    public CommentPredicate(ChangeIndex index, String value) {
        super(ChangeField.COMMENT, value);
        this.index = index;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        try {
            Predicate p = Predicate.and(new LegacyChangeIdPredicate(object.getId()), this);
            for (ChangeData cData : this.index.getSource(p, IndexedChangeQuery.oneResult()).read()) {
                if (!cData.getId().equals(object.getId())) continue;
                return true;
            }
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

