/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

class ReviewerByEmailPredicate
extends ChangeIndexPredicate {
    private final ReviewerStateInternal state;
    private final Address adr;

    static Predicate<ChangeData> forState(Address adr, ReviewerStateInternal state) {
        Preconditions.checkArgument(state != ReviewerStateInternal.REMOVED, "can't query by removed reviewer");
        return new ReviewerByEmailPredicate(state, adr);
    }

    private ReviewerByEmailPredicate(ReviewerStateInternal state, Address adr) {
        super(ChangeField.REVIEWER_BY_EMAIL, ChangeField.getReviewerByEmailFieldValue(state, adr));
        this.state = state;
        this.adr = adr;
    }

    Address getAddress() {
        return this.adr;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.reviewersByEmail().asTable().get((Object)this.state, this.adr) != null;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

