/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.inject.Inject;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Config;

class H2
extends BaseDataSourceType {
    protected final Config cfg;
    private final SitePaths site;

    @Inject
    H2(SitePaths site, @GerritServerConfig Config cfg) {
        super("org.h2.Driver");
        this.cfg = cfg;
        this.site = site;
    }

    @Override
    public String getUrl() {
        String database = this.cfg.getString("database", null, "database");
        if (database == null || database.isEmpty()) {
            database = "db/ReviewDB";
        }
        return H2.appendUrlOptions(this.cfg, H2.createUrl(this.site.resolve(database)));
    }

    public static String createUrl(Path path) {
        return "jdbc:h2:" + path.toUri().toString();
    }

    public static String appendUrlOptions(Config cfg, String url) {
        long h2CacheSize = cfg.getLong("database", "h2", "cacheSize", -1L);
        boolean h2AutoServer = cfg.getBoolean("database", "h2", "autoServer", false);
        StringBuilder urlBuilder = new StringBuilder().append(url);
        if (h2CacheSize >= 0L) {
            urlBuilder.append(";CACHE_SIZE=").append(h2CacheSize / 1024L);
        }
        if (h2AutoServer) {
            urlBuilder.append(";AUTO_SERVER=TRUE");
        }
        return urlBuilder.toString();
    }
}

