/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_130;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_131
extends SchemaVersion {
    private static final String COMMIT_MSG = "Rename 'Push Annotated/Signed Tag' permission to 'Create Annotated/Signed Tag'";
    private final GitRepositoryManager repoManager;
    private final PersonIdent serverUser;

    @Inject
    Schema_131(Provider<Schema_130> prior, GitRepositoryManager repoManager, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        SortedSet<Project.NameKey> repoList = this.repoManager.list();
        TreeSet<Project.NameKey> repoUpgraded = new TreeSet<Project.NameKey>();
        ui.message("\tMigrating " + repoList.size() + " repositories ...");
        for (Project.NameKey projectName : repoList) {
            try {
                Repository git = this.repoManager.openRepository(projectName);
                Throwable throwable = null;
                try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, projectName, git);){
                    ProjectConfig config = ProjectConfig.read(md);
                    if (!config.hasLegacyPermissions()) continue;
                    md.getCommitBuilder().setAuthor(this.serverUser);
                    md.getCommitBuilder().setCommitter(this.serverUser);
                    md.setMessage(COMMIT_MSG);
                    config.commit(md);
                    repoUpgraded.add(projectName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (git == null) continue;
                    Schema_131.$closeResource(throwable, git);
                }
            }
            catch (IOException | ConfigInvalidException ex) {
                throw new OrmException("Cannot migrate project " + projectName, ex);
            }
        }
        ui.message("\tMigration completed:  " + repoUpgraded.size() + " repositories updated:");
        ui.message("\t" + repoUpgraded.stream().map(n -> n.get()).collect(Collectors.joining(" ")));
    }
}

