/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;

class HostKeyProvider
implements Provider<KeyPairProvider> {
    private final SitePaths site;

    @Inject
    HostKeyProvider(SitePaths site) {
        this.site = site;
    }

    @Override
    public KeyPairProvider get() {
        Path objKey = this.site.ssh_key;
        Path rsaKey = this.site.ssh_rsa;
        Path dsaKey = this.site.ssh_dsa;
        Path ecdsaKey_256 = this.site.ssh_ecdsa_256;
        Path ecdsaKey_384 = this.site.ssh_ecdsa_384;
        Path ecdsaKey_521 = this.site.ssh_ecdsa_521;
        Path ed25519Key = this.site.ssh_ed25519;
        ArrayList<File> stdKeys = new ArrayList<File>(6);
        if (Files.exists(rsaKey, new LinkOption[0])) {
            stdKeys.add(rsaKey.toAbsolutePath().toFile());
        }
        if (Files.exists(dsaKey, new LinkOption[0])) {
            stdKeys.add(dsaKey.toAbsolutePath().toFile());
        }
        if (Files.exists(ecdsaKey_256, new LinkOption[0])) {
            stdKeys.add(ecdsaKey_256.toAbsolutePath().toFile());
        }
        if (Files.exists(ecdsaKey_384, new LinkOption[0])) {
            stdKeys.add(ecdsaKey_384.toAbsolutePath().toFile());
        }
        if (Files.exists(ecdsaKey_521, new LinkOption[0])) {
            stdKeys.add(ecdsaKey_521.toAbsolutePath().toFile());
        }
        if (Files.exists(ed25519Key, new LinkOption[0])) {
            stdKeys.add(ed25519Key.toAbsolutePath().toFile());
        }
        if (Files.exists(objKey, new LinkOption[0])) {
            if (stdKeys.isEmpty()) {
                SimpleGeneratorHostKeyProvider p = new SimpleGeneratorHostKeyProvider();
                p.setPath(objKey.toAbsolutePath());
                return p;
            }
            stdKeys.add(objKey.toAbsolutePath().toFile());
            throw new ProvisionException("Multiple host keys exist: " + stdKeys);
        }
        if (stdKeys.isEmpty()) {
            throw new ProvisionException("No SSH keys under " + this.site.etc_dir);
        }
        FileKeyPairProvider kp = new FileKeyPairProvider();
        kp.setFiles(stdKeys);
        return kp;
    }
}

