/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectDB2
extends SqlDialect {
    public DialectDB2() {
        this.typeNames.put(-1, "CLOB");
    }

    @Override
    public boolean handles(String url, Connection c) {
        return url.startsWith("jdbc:db2:");
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        switch (DialectDB2.getSQLStateInt(err)) {
            case 23505: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }

    @Override
    protected String getNextSequenceValueSql(String seqname) {
        return "VALUES NEXT VALUE FOR " + seqname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT SEQNAME FROM SYSCAT.SEQUENCES WHERE SEQSCHEMA = CURRENT_SCHEMA");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listTables(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT TABNAME FROM SYSCAT.TABLES WHERE TABSCHEMA = CURRENT_SCHEMA");
            try {
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    tables.add(rs.getString(1).toLowerCase());
                }
                hashSet = tables;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listIndexes(Connection db, String tableName) throws SQLException {
        try (PreparedStatement s = db.prepareStatement("SELECT distinct INDNAME FROM syscat.indexes WHERE TABNAME = ? AND TABSCHEMA = CURRENT_SCHEMA");){
            HashSet<String> hashSet;
            s.setString(1, tableName.toUpperCase());
            ResultSet rs = s.executeQuery();
            try {
                HashSet<String> indexes = new HashSet<String>();
                while (rs.next()) {
                    indexes.add(rs.getString(1).toLowerCase());
                }
                hashSet = indexes;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    @Override
    public void renameTable(StatementExecutor e, String from, String to) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("RENAME TABLE ");
        r.append(from);
        r.append(" TO ");
        r.append(to);
        e.execute(r.toString());
    }

    @Override
    public void renameColumn(StatementExecutor stmt, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" RENAME COLUMN ");
        r.append(fromColumn);
        r.append(" TO ");
        r.append(col.getColumnName());
        stmt.execute(r.toString());
    }

    @Override
    public boolean isStatementDelimiterSupported() {
        return false;
    }
}

