/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.TombstoneValue;
import java.io.IOException;

public abstract class DetachableSoyValueProvider
implements SoyValueProvider {
    protected SoyValue resolvedValue = TombstoneValue.INSTANCE;

    @Override
    public final SoyValue resolve() {
        SoyValue local = this.resolvedValue;
        Preconditions.checkState(local != TombstoneValue.INSTANCE, "called resolve() before status() returned ready.");
        return local;
    }

    @Override
    public final RenderResult status() {
        if (this.resolvedValue != TombstoneValue.INSTANCE) {
            return RenderResult.done();
        }
        return this.doResolve();
    }

    @Override
    public RenderResult renderAndResolve(AdvisingAppendable appendable, boolean isLast) throws IOException {
        RenderResult result = this.status();
        if (result.type() == RenderResult.Type.DONE) {
            SoyValue resolved = this.resolve();
            if (resolved == null) {
                appendable.append("null");
            } else {
                resolved.render(appendable);
            }
        }
        return result;
    }

    protected abstract RenderResult doResolve();
}

