/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_BinaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;

@Immutable
abstract class BinaryOperation
extends Operation {
    BinaryOperation() {
    }

    abstract String operator();

    abstract CodeChunk.WithValue arg1();

    abstract CodeChunk.WithValue arg2();

    static CodeChunk.WithValue create(Operator operator, CodeChunk.WithValue arg1, CodeChunk.WithValue arg2) {
        Preconditions.checkState(operator != Operator.AND, "use BinaryOperation::and");
        Preconditions.checkState(operator != Operator.OR, "use BinaryOperation::or");
        return BinaryOperation.create(operator.getTokenString(), operator.getPrecedence(), operator.getAssociativity(), arg1, arg2);
    }

    static BinaryOperation create(String operator, int precedence, Operator.Associativity associativity, CodeChunk.WithValue arg1, CodeChunk.WithValue arg2) {
        return new AutoValue_BinaryOperation((ImmutableSet<CodeChunk>)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(arg1.initialStatements())).addAll(arg2.initialStatements())).build(), precedence, associativity, operator, arg1, arg2);
    }

    static CodeChunk.WithValue and(CodeChunk.WithValue lhs, CodeChunk.WithValue rhs, CodeChunk.Generator codeGenerator) {
        if (lhs.initialStatements().containsAll(rhs.initialStatements())) {
            return BinaryOperation.create("&&", Operator.AND.getPrecedence(), Operator.AND.getAssociativity(), lhs, rhs);
        }
        CodeChunk.WithValue tmp = codeGenerator.declare(lhs).ref();
        return Composite.create(ImmutableList.of(CodeChunk.ifStatement(tmp, tmp.assign(rhs)).build()), tmp);
    }

    static CodeChunk.WithValue or(CodeChunk.WithValue lhs, CodeChunk.WithValue rhs, CodeChunk.Generator codeGenerator) {
        if (lhs.initialStatements().containsAll(rhs.initialStatements())) {
            return BinaryOperation.create("||", Operator.OR.getPrecedence(), Operator.OR.getAssociativity(), lhs, rhs);
        }
        CodeChunk.WithValue tmp = codeGenerator.declare(lhs).ref();
        return Composite.create(ImmutableList.of(CodeChunk.ifStatement(BinaryOperation.not(tmp), tmp.assign(rhs)).build()), tmp);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.arg1().collectRequires(collector);
        this.arg2().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.arg1(), OperandPosition.LEFT, ctx);
        ctx.append(' ').append(this.operator()).append(' ');
        this.formatOperand(this.arg2(), OperandPosition.RIGHT, ctx);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.arg1()).appendInitialStatements(this.arg2());
    }
}

