/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class SoyMsgBundleImpl
extends SoyMsgBundle {
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;
    private final Map<Long, SoyMsg> msgMap;

    public SoyMsgBundleImpl(@Nullable String localeString, List<SoyMsg> msgs) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        TreeMap<Long, SoyMsg> tempMsgMap = Maps.newTreeMap();
        for (SoyMsg msg : msgs) {
            Preconditions.checkArgument(Objects.equals(msg.getLocaleString(), localeString));
            long msgId = msg.getId();
            if (!tempMsgMap.containsKey(msgId)) {
                tempMsgMap.put(msgId, msg);
                continue;
            }
            SoyMsg existingMsg = (SoyMsg)tempMsgMap.get(msgId);
            for (SourceLocation source : msg.getSourceLocations()) {
                existingMsg.addSourceLocation(source);
            }
        }
        this.msgMap = ImmutableMap.copyOf(tempMsgMap);
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    @Nullable
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    @Override
    public SoyMsg getMsg(long msgId) {
        return this.msgMap.get(msgId);
    }

    @Override
    public int getNumMsgs() {
        return this.msgMap.size();
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return this.msgMap.values().iterator();
    }
}

