/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class JavaObjectTerm
extends Term {
    protected Object obj;

    public JavaObjectTerm(Object object) {
        this.obj = object;
    }

    public void setObject(Object object) {
        this.obj = object;
    }

    public Object object() {
        return this.obj;
    }

    public Class<?> getClazz() {
        return this.obj.getClass();
    }

    @Override
    public String name() {
        return "";
    }

    @Override
    public String toQuotedString() {
        return this.toString();
    }

    @Override
    public int type() {
        return 7;
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if (term instanceof VariableTerm) {
            return ((VariableTerm)term).unify(this, trail);
        }
        if (!(term instanceof JavaObjectTerm)) {
            return false;
        }
        return this.obj.equals(((JavaObjectTerm)term).obj);
    }

    @Override
    public boolean convertible(Class<?> clazz) {
        return JavaObjectTerm.convertible(this.obj.getClass(), clazz);
    }

    @Override
    public Object toJava() {
        return this.obj;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaObjectTerm)) {
            return false;
        }
        return this.obj.equals(((JavaObjectTerm)object).obj);
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public String toString() {
        return this.obj.getClass().getName() + "(0x" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public int compareTo(Term term) {
        if (term instanceof VariableTerm || term instanceof IntegerTerm || term instanceof DoubleTerm || term instanceof SymbolTerm || term instanceof ListTerm || term instanceof StructureTerm) {
            return 1;
        }
        if (!(term instanceof JavaObjectTerm)) {
            return -1;
        }
        if (this.obj.equals(((JavaObjectTerm)term).obj)) {
            return 0;
        }
        return this.obj.hashCode() - ((JavaObjectTerm)term).obj.hashCode();
    }
}

