/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthService;

public abstract class AbstractServerSession
extends AbstractSession
implements ServerSession {
    private ServerProxyAcceptor proxyAcceptor;
    private SocketAddress clientAddress;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private GSSAuthenticator gssAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private List<NamedFactory<UserAuth>> userAuthFactories;

    protected AbstractServerSession(ServerFactoryManager factoryManager, IoSession ioSession) {
        super(true, factoryManager, ioSession);
    }

    @Override
    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)super.getFactoryManager();
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.resolveEffectiveProvider(ServerProxyAcceptor.class, this.proxyAcceptor, this.getFactoryManager().getServerProxyAcceptor());
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor proxyAcceptor) {
        this.proxyAcceptor = proxyAcceptor;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.resolvePeerAddress(this.clientAddress);
    }

    public void setClientAddress(SocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.resolveEffectiveProvider(PasswordAuthenticator.class, this.passwordAuthenticator, this.getFactoryManager().getPasswordAuthenticator());
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.resolveEffectiveProvider(PublickeyAuthenticator.class, this.publickeyAuthenticator, this.getFactoryManager().getPublickeyAuthenticator());
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        return this.resolveEffectiveProvider(KeyboardInteractiveAuthenticator.class, this.interactiveAuthenticator, this.getFactoryManager().getKeyboardInteractiveAuthenticator());
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator interactiveAuthenticator) {
        this.interactiveAuthenticator = interactiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.resolveEffectiveProvider(GSSAuthenticator.class, this.gssAuthenticator, this.getFactoryManager().getGSSAuthenticator());
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        return this.resolveEffectiveProvider(HostBasedAuthenticator.class, this.hostBasedAuthenticator, this.getFactoryManager().getHostBasedAuthenticator());
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.resolveEffectiveFactories(UserAuth.class, this.userAuthFactories, this.getFactoryManager().getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    protected IoWriteFuture sendServerIdentification(String ... headerLines) {
        String ident = this.serverVersion = this.resolveIdentificationString("server-identification");
        if (GenericUtils.length(headerLines) > 0) {
            ident = GenericUtils.join(headerLines, (CharSequence)"\r\n") + "\r\n" + this.serverVersion;
        }
        return this.sendIdentification(ident);
    }

    @Override
    protected void checkKeys() {
    }

    @Override
    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        ServerUserAuthService authService;
        boolean started = super.handleServiceRequest(serviceName, buffer);
        if (!started) {
            return false;
        }
        if ("ssh-userauth".equals(serviceName) && this.currentService instanceof ServerUserAuthService && WelcomeBannerPhase.IMMEDIATE.equals((Object)(authService = (ServerUserAuthService)this.currentService).getWelcomePhase())) {
            authService.sendWelcomeBanner(this);
        }
        return true;
    }

    @Override
    public void startService(String name) throws Exception {
        ServerFactoryManager factoryManager = this.getFactoryManager();
        this.currentService = ServiceFactory.create(factoryManager.getServiceFactories(), ValidateUtils.checkNotNullAndNotEmpty(name, "No service name"), this);
        if (this.currentService == null) {
            throw new SshException(7, "Unknown service: " + name);
        }
    }

    @Override
    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        super.handleServiceAccept(serviceName, buffer);
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT for " + serviceName);
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        this.mergeProposals(this.serverProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(seed, "No KEX seed");
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager proposedManager) {
        Iterable<String> provided;
        ValidateUtils.checkTrue(proposedManager == this.getFactoryManager(), "Mismatched signatures proposed factory manager");
        KeyPairProvider kpp = this.getKeyPairProvider();
        List<String> supported = NamedResource.getNameList(this.getSignatureFactories());
        try {
            provided = kpp == null ? null : kpp.getKeyTypes();
        }
        catch (Error e) {
            this.log.warn("resolveAvailableSignaturesProposal({}) failed ({}) to get key types: {}", this, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAvailableSignaturesProposal(" + this + ") fetch key types failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        if (provided == null || GenericUtils.isEmpty(supported)) {
            return this.resolveEmptySignaturesProposal(supported, provided);
        }
        StringBuilder resolveKeys = null;
        for (String keyType : provided) {
            if (!supported.contains(keyType)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("resolveAvailableSignaturesProposal({})[{}] {} not in supported list: {}", this, provided, keyType, supported);
                continue;
            }
            if (resolveKeys == null) {
                resolveKeys = new StringBuilder(supported.size() * 16);
            }
            if (resolveKeys.length() > 0) {
                resolveKeys.append(',');
            }
            resolveKeys.append(keyType);
        }
        if (GenericUtils.isEmpty(resolveKeys)) {
            return this.resolveEmptySignaturesProposal(supported, provided);
        }
        return resolveKeys.toString();
    }

    protected String resolveEmptySignaturesProposal(Iterable<String> supported, Iterable<String> provided) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveEmptySignaturesProposal({})[{}] none of the keys appears in supported list: {}", this, provided, supported);
        }
        return null;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        List<String> ident;
        int numLines;
        ServerProxyAcceptor acceptor = this.getServerProxyAcceptor();
        int rpos = buffer.rpos();
        if (acceptor != null) {
            try {
                boolean completed = acceptor.acceptServerProxyMetadata(this, buffer);
                if (!completed) {
                    buffer.rpos(rpos);
                    return false;
                }
            }
            catch (Throwable t) {
                this.log.warn("readIdentification({}) failed ({}) to accept proxy metadata: {}", this, t.getClass().getSimpleName(), t.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("readIdentification(" + this + ") proxy metadata acceptance failure details", t);
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new SshException(t);
            }
        }
        String string = this.clientVersion = (numLines = GenericUtils.size(ident = this.doReadIdentification(buffer, true))) <= 0 ? null : ident.remove(numLines - 1);
        if (GenericUtils.isEmpty(this.clientVersion)) {
            buffer.rpos(rpos);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("readIdentification({}) client version string: {}", (Object)this, (Object)this.clientVersion);
        }
        String errorMessage = null;
        if (!Session.isValidVersionPrefix(this.clientVersion)) {
            errorMessage = "Unsupported protocol version: " + this.clientVersion;
        }
        if (errorMessage == null && numLines > 1) {
            errorMessage = "Unexpected extra " + (numLines - 1) + " lines from client=" + this.clientVersion;
        }
        if (GenericUtils.length(errorMessage) > 0) {
            this.ioSession.write(new ByteArrayBuffer((errorMessage + "\n").getBytes(StandardCharsets.UTF_8))).addListener(future -> this.close(true));
            throw new SshException(errorMessage);
        }
        this.kexState.set(KexState.INIT);
        this.sendKexInit();
        return true;
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.clientProposal, proposal);
        this.i_c = seed;
    }

    @Override
    public KeyPair getHostKey() {
        String keyType = this.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        KeyPairProvider provider = Objects.requireNonNull(this.getKeyPairProvider(), "No host keys provider");
        try {
            return provider.loadKey(keyType);
        }
        catch (Error e) {
            this.log.warn("getHostKey({}) failed ({}) to load key of type={}: {}", this, e.getClass().getSimpleName(), keyType, e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("getHostKey(" + this + ") " + keyType + " key load failure details", e);
            }
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public int getActiveSessionCountForUser(String userName) {
        if (GenericUtils.isEmpty(userName)) {
            return 0;
        }
        IoService service = this.ioSession.getService();
        Map<Long, IoSession> sessionsMap = service.getManagedSessions();
        if (GenericUtils.isEmpty(sessionsMap)) {
            return 0;
        }
        int totalCount = 0;
        for (IoSession is : sessionsMap.values()) {
            String sessionUser;
            ServerSession session = (ServerSession)((Object)AbstractServerSession.getSession(is, true));
            if (session == null || GenericUtils.isEmpty(sessionUser = session.getUsername()) || !Objects.equals(sessionUser, userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public long getId() {
        return this.ioSession.getId();
    }
}

