lexer grammar Query;
options {
  language=Java;

}

@members {
    public void displayRecognitionError(String[] tokenNames,
                                        RecognitionException e) {
        String hdr = getErrorHeader(e);
        String msg = getErrorMessage(e, tokenNames);
        throw new QueryParseInternalException(hdr + " " + msg);
    }
}
@header {
package com.google.gwtorm.schema;
}

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 211
WHERE: 'WHERE' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 212
ORDER: 'ORDER' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 213
BY:    'BY'    ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 214
AND:   'AND'   ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 215
ASC:   'ASC'   ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 216
DESC:  'DESC'  ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 217
LIMIT: 'LIMIT' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 218
TRUE:  'true'  ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 219
FALSE: 'false' ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 221
LT : '<'  ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 222
LE : '<=' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 223
GT : '>'  ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 224
GE : '>=' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 225
EQ : '='  ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 227
PLACEHOLDER: '?' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 228
COMMA: ',' ;
// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 229
DOT: '.' ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 231
CONSTANT_INTEGER
  : '0'
  | '1'..'9' ('0'..'9')*
  ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 236
CONSTANT_STRING
  : '\'' ( ~('\'') )* '\''
  ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 240
ID
  : ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
  ;

// $ANTLR src "/Users/dpursehouse/git/gwtorm/src/main/antlr/com/google/gwtorm/schema/Query.g" 244
WS
  :  ( ' ' | '\r' | '\t' | '\n' ) { $channel=HIDDEN; }
  ;
