/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class ProjectAccessUtil {
    public static List<AccessSection> mergeSections(List<AccessSection> src) {
        LinkedHashMap<String, AccessSection> map = new LinkedHashMap<String, AccessSection>();
        for (AccessSection section : src) {
            if (section.getPermissions().isEmpty()) continue;
            AccessSection prior = (AccessSection)map.get(section.getName());
            if (prior != null) {
                prior.mergeFrom(section);
                continue;
            }
            map.put(section.getName(), section);
        }
        return new ArrayList<AccessSection>(map.values());
    }

    public static List<AccessSection> removeEmptyPermissionsAndSections(List<AccessSection> src) {
        HashSet<AccessSection> sectionsToRemove = new HashSet<AccessSection>();
        for (AccessSection section : src) {
            HashSet<Permission> permissionsToRemove = new HashSet<Permission>();
            for (Permission permission : section.getPermissions()) {
                if (!permission.getRules().isEmpty()) continue;
                permissionsToRemove.add(permission);
            }
            for (Permission permissionToRemove : permissionsToRemove) {
                section.remove(permissionToRemove);
            }
            if (!section.getPermissions().isEmpty()) continue;
            sectionsToRemove.add(section);
        }
        for (AccessSection sectionToRemove : sectionsToRemove) {
            src.remove(sectionToRemove);
        }
        return src;
    }
}

