/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Account;

public class AccountInfo {
    protected Account.Id id;
    protected String fullName;
    protected String preferredEmail;

    protected AccountInfo() {
    }

    public AccountInfo(Account.Id id) {
        this.id = id;
    }

    public AccountInfo(Account a) {
        this.id = a.getId();
        this.fullName = a.getFullName();
        this.preferredEmail = a.getPreferredEmail();
    }

    public Account.Id getId() {
        return this.id;
    }

    public void setFullName(String n) {
        this.fullName = n;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public void setPreferredEmail(String email) {
        this.preferredEmail = email;
    }

    public String getName(String anonymousCowardName) {
        if (this.getFullName() != null) {
            return this.getFullName();
        }
        if (this.getPreferredEmail() != null) {
            return this.getPreferredEmail();
        }
        return this.getNameEmail(anonymousCowardName);
    }

    public String getNameEmail(String anonymousCowardName) {
        String name = this.getFullName();
        if (name == null) {
            name = anonymousCowardName;
        }
        StringBuilder b = new StringBuilder();
        b.append(name);
        if (this.getPreferredEmail() != null) {
            b.append(" <");
            b.append(this.getPreferredEmail());
            b.append(">");
        } else if (this.getId() != null) {
            b.append(" (");
            b.append(this.getId().get());
            b.append(")");
        }
        return b.toString();
    }
}

