/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import java.util.List;
import java.util.Set;

public class ChangeDetail {
    protected AccountInfoCache accounts;
    protected boolean allowsAnonymous;
    protected boolean canAbandon;
    protected boolean canEditCommitMessage;
    protected boolean canCherryPick;
    protected boolean canPublish;
    protected boolean canRebase;
    protected boolean canRestore;
    protected boolean canRevert;
    protected boolean canDeleteDraft;
    protected Change change;
    protected boolean starred;
    protected List<ChangeInfo> dependsOn;
    protected List<ChangeInfo> neededBy;
    protected List<PatchSet> patchSets;
    protected Set<PatchSet.Id> patchSetsWithDraftComments;
    protected List<SubmitRecord> submitRecords;
    protected Project.SubmitType submitType;
    protected SubmitTypeRecord submitTypeRecord;
    protected boolean canSubmit;
    protected List<ChangeMessage> messages;
    protected PatchSet.Id currentPatchSetId;
    protected PatchSetDetail currentDetail;
    protected boolean canEdit;
    protected boolean canEditTopicName;

    public AccountInfoCache getAccounts() {
        return this.accounts;
    }

    public void setAccounts(AccountInfoCache aic) {
        this.accounts = aic;
    }

    public boolean isAllowsAnonymous() {
        return this.allowsAnonymous;
    }

    public void setAllowsAnonymous(boolean anon) {
        this.allowsAnonymous = anon;
    }

    public boolean canAbandon() {
        return this.canAbandon;
    }

    public void setCanAbandon(boolean a) {
        this.canAbandon = a;
    }

    public boolean canEditCommitMessage() {
        return this.canEditCommitMessage;
    }

    public void setCanEditCommitMessage(boolean a) {
        this.canEditCommitMessage = a;
    }

    public boolean canCherryPick() {
        return this.canCherryPick;
    }

    public void setCanCherryPick(boolean a) {
        this.canCherryPick = a;
    }

    public boolean canPublish() {
        return this.canPublish;
    }

    public void setCanPublish(boolean a) {
        this.canPublish = a;
    }

    public boolean canRebase() {
        return this.canRebase;
    }

    public void setCanRebase(boolean a) {
        this.canRebase = a;
    }

    public boolean canRestore() {
        return this.canRestore;
    }

    public void setCanRestore(boolean a) {
        this.canRestore = a;
    }

    public boolean canRevert() {
        return this.canRevert;
    }

    public void setCanRevert(boolean a) {
        this.canRevert = a;
    }

    public boolean canSubmit() {
        return this.canSubmit;
    }

    public void setCanSubmit(boolean a) {
        this.canSubmit = a;
    }

    public boolean canDeleteDraft() {
        return this.canDeleteDraft;
    }

    public void setCanDeleteDraft(boolean a) {
        this.canDeleteDraft = a;
    }

    public boolean canEditTopicName() {
        return this.canEditTopicName;
    }

    public void setCanEditTopicName(boolean a) {
        this.canEditTopicName = a;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
        this.currentPatchSetId = change.currentPatchSetId();
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean s) {
        this.starred = s;
    }

    public List<ChangeInfo> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<ChangeInfo> d) {
        this.dependsOn = d;
    }

    public List<ChangeInfo> getNeededBy() {
        return this.neededBy;
    }

    public void setNeededBy(List<ChangeInfo> d) {
        this.neededBy = d;
    }

    public List<ChangeMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChangeMessage> m) {
        this.messages = m;
    }

    public List<PatchSet> getPatchSets() {
        return this.patchSets;
    }

    public void setPatchSets(List<PatchSet> s) {
        this.patchSets = s;
    }

    public void setPatchSetsWithDraftComments(Set<PatchSet.Id> pwdc) {
        this.patchSetsWithDraftComments = pwdc;
    }

    public boolean hasDraftComments(PatchSet.Id id) {
        return this.patchSetsWithDraftComments.contains(id);
    }

    public void setSubmitRecords(List<SubmitRecord> all) {
        this.submitRecords = all;
    }

    public List<SubmitRecord> getSubmitRecords() {
        return this.submitRecords;
    }

    public void setSubmitTypeRecord(SubmitTypeRecord submitTypeRecord) {
        this.submitTypeRecord = submitTypeRecord;
    }

    public SubmitTypeRecord getSubmitTypeRecord() {
        return this.submitTypeRecord;
    }

    public boolean isCurrentPatchSet(PatchSetDetail detail) {
        return this.currentPatchSetId != null && detail.getPatchSet().getId().equals(this.currentPatchSetId);
    }

    public PatchSet getCurrentPatchSet() {
        if (this.currentPatchSetId != null) {
            for (int i = this.patchSets.size() - 1; i >= 0; --i) {
                PatchSet ps = this.patchSets.get(i);
                if (!ps.getId().equals(this.currentPatchSetId)) continue;
                return ps;
            }
        }
        return null;
    }

    public PatchSetDetail getCurrentPatchSetDetail() {
        return this.currentDetail;
    }

    public void setCurrentPatchSetDetail(PatchSetDetail d) {
        this.currentDetail = d;
    }

    public void setCurrentPatchSetId(PatchSet.Id id) {
        this.currentPatchSetId = id;
    }

    public String getDescription() {
        return this.currentDetail != null ? this.currentDetail.getInfo().getMessage() : "";
    }

    public void setCanEdit(boolean a) {
        this.canEdit = a;
    }

    public boolean canEdit() {
        return this.canEdit;
    }
}

