/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.PermissionRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContributorAgreement
implements Comparable<ContributorAgreement> {
    protected String name;
    protected String description;
    protected List<PermissionRule> accepted;
    protected boolean requireContactInformation;
    protected GroupReference autoVerify;
    protected String agreementUrl;

    protected ContributorAgreement() {
    }

    public ContributorAgreement(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<PermissionRule> getAccepted() {
        if (this.accepted == null) {
            this.accepted = new ArrayList<PermissionRule>();
        }
        return this.accepted;
    }

    public void setAccepted(List<PermissionRule> accepted) {
        this.accepted = accepted;
    }

    public boolean isRequireContactInformation() {
        return this.requireContactInformation;
    }

    public void setRequireContactInformation(boolean requireContactInformation) {
        this.requireContactInformation = requireContactInformation;
    }

    public GroupReference getAutoVerify() {
        return this.autoVerify;
    }

    public void setAutoVerify(GroupReference autoVerify) {
        this.autoVerify = autoVerify;
    }

    public String getAgreementUrl() {
        return this.agreementUrl;
    }

    public void setAgreementUrl(String agreementUrl) {
        this.agreementUrl = agreementUrl;
    }

    @Override
    public int compareTo(ContributorAgreement o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "ContributorAgreement[" + this.getName() + "]";
    }

    public ContributorAgreement forUi() {
        ContributorAgreement ca = new ContributorAgreement(this.name);
        ca.description = this.description;
        ca.accepted = Collections.emptyList();
        ca.requireContactInformation = this.requireContactInformation;
        if (this.autoVerify != null) {
            ca.autoVerify = new GroupReference();
        }
        ca.agreementUrl = this.agreementUrl;
        return ca;
    }
}

