/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

public class GitWebType {
    private String name;
    private String revision;
    private String project;
    private String branch;
    private String rootTree;
    private String file;
    private String fileHistory;
    private char pathSeparator = (char)47;
    private boolean linkDrafts;
    private boolean urlEncode;

    public static GitWebType fromName(String name) {
        GitWebType type;
        if (name == null || name.isEmpty() || name.equalsIgnoreCase("gitweb")) {
            type = new GitWebType();
            type.setLinkName("gitweb");
            type.setProject("?p=${project}.git;a=summary");
            type.setRevision("?p=${project}.git;a=commit;h=${commit}");
            type.setBranch("?p=${project}.git;a=shortlog;h=${branch}");
            type.setRootTree("?p=${project}.git;a=tree;hb=${commit}");
            type.setFile("?p=${project}.git;hb=${commit};f=${file}");
            type.setFileHistory("?p=${project}.git;a=history;hb=${branch};f=${file}");
        } else if (name.equalsIgnoreCase("cgit")) {
            type = new GitWebType();
            type.setLinkName("cgit");
            type.setProject("${project}.git/summary");
            type.setRevision("${project}.git/commit/?id=${commit}");
            type.setBranch("${project}.git/log/?h=${branch}");
            type.setRootTree("${project}.git/tree/?h=${commit}");
            type.setFile("${project}.git/tree/${file}?h=${commit}");
            type.setFileHistory("${project}.git/log/${file}?h=${branch}");
        } else if (name.equalsIgnoreCase("custom")) {
            type = new GitWebType();
            type.setLinkName("gitweb");
        } else {
            type = name.equalsIgnoreCase("disabled") ? null : null;
        }
        return type;
    }

    protected GitWebType() {
    }

    public String getBranch() {
        return this.branch;
    }

    public String getLinkName() {
        return this.name;
    }

    public String getProject() {
        return this.project;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRootTree() {
        return this.rootTree;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileHistory() {
        return this.fileHistory;
    }

    public boolean getLinkDrafts() {
        return this.linkDrafts;
    }

    public void setBranch(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.branch = pattern;
        }
    }

    public void setLinkName(String name) {
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    public void setProject(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.project = pattern;
        }
    }

    public void setRevision(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.revision = pattern;
        }
    }

    public void setRootTree(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.rootTree = pattern;
        }
    }

    public void setFile(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.file = pattern;
        }
    }

    public void setFileHistory(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.fileHistory = pattern;
        }
    }

    public String replacePathSeparator(String urlSegment) {
        if ('/' != this.pathSeparator) {
            return urlSegment.replace('/', this.pathSeparator);
        }
        return urlSegment;
    }

    public void setPathSeparator(char separator) {
        this.pathSeparator = separator;
    }

    public void setLinkDrafts(boolean linkDrafts) {
        this.linkDrafts = linkDrafts;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setUrlEncode(boolean urlEncode) {
        this.urlEncode = urlEncode;
    }
}

