/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

public class LabelValue {
    protected short value;
    protected String text;

    public static String formatValue(short value) {
        if (value < 0) {
            return Short.toString(value);
        }
        if (value == 0) {
            return " 0";
        }
        return "+" + Short.toString(value);
    }

    public LabelValue(short value, String text) {
        this.value = value;
        this.text = text;
    }

    protected LabelValue() {
    }

    public short getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public String formatValue() {
        return LabelValue.formatValue(this.value);
    }

    public String format() {
        StringBuilder sb = new StringBuilder(this.formatValue());
        if (!this.text.isEmpty()) {
            sb.append(' ').append(this.text);
        }
        return sb.toString();
    }

    public String toString() {
        return this.format();
    }
}

