/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterizedString {
    private final String pattern;
    private final String rawPattern;
    private final List<Format> patternOps;
    private final List<Parameter> parameters;
    private static final Map<String, Function> FUNCTIONS = ParameterizedString.initFunctions();

    public static ParameterizedString asis(String constant) {
        return new ParameterizedString(new Constant(constant));
    }

    protected ParameterizedString() {
        this(new Constant(""));
    }

    private ParameterizedString(Constant c) {
        this.pattern = c.text;
        this.rawPattern = c.text;
        this.patternOps = Collections.singletonList(c);
        this.parameters = Collections.emptyList();
    }

    public ParameterizedString(String pattern) {
        int e;
        int b;
        StringBuilder raw = new StringBuilder();
        ArrayList<Parameter> prs = new ArrayList<Parameter>(4);
        ArrayList<Format> ops = new ArrayList<Format>(4);
        int i = 0;
        while (i < pattern.length() && (b = pattern.indexOf("${", i)) >= 0 && (e = pattern.indexOf("}", b + 2)) >= 0) {
            raw.append(pattern.substring(i, b));
            ops.add(new Constant(pattern.substring(i, b)));
            Parameter p = new Parameter(pattern.substring(b + 2, e));
            raw.append("{").append(prs.size()).append("}");
            prs.add(p);
            ops.add(p);
            i = e + 1;
        }
        if (i < pattern.length()) {
            raw.append(pattern.substring(i));
            ops.add(new Constant(pattern.substring(i)));
        }
        this.pattern = pattern;
        this.rawPattern = raw.toString();
        this.patternOps = Collections.unmodifiableList(ops);
        this.parameters = Collections.unmodifiableList(prs);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRawPattern() {
        return this.rawPattern;
    }

    public List<String> getParameterNames() {
        ArrayList<String> r = new ArrayList<String>(this.parameters.size());
        for (Parameter p : this.parameters) {
            r.add(p.name);
        }
        return Collections.unmodifiableList(r);
    }

    public String[] bind(Map<String, String> params) {
        String[] r = new String[this.parameters.size()];
        for (int i = 0; i < r.length; ++i) {
            StringBuilder b = new StringBuilder();
            this.parameters.get(i).format(b, params);
            r[i] = b.toString();
        }
        return r;
    }

    public String replace(Map<String, String> params) {
        StringBuilder r = new StringBuilder();
        for (Format f : this.patternOps) {
            f.format(r, params);
        }
        return r.toString();
    }

    public Builder replace(String name, String value) {
        return new Builder().replace(name, value);
    }

    public String toString() {
        return this.getPattern();
    }

    private static Map<String, Function> initFunctions() {
        HashMap<String, Function> m = new HashMap<String, Function>();
        m.put("toLowerCase", new Function(){

            @Override
            String apply(String a) {
                return a.toLowerCase();
            }
        });
        m.put("toUpperCase", new Function(){

            @Override
            String apply(String a) {
                return a.toUpperCase();
            }
        });
        m.put("localPart", new Function(){

            @Override
            String apply(String a) {
                int at = a.indexOf(64);
                return at < 0 ? a : a.substring(0, at);
            }
        });
        return Collections.unmodifiableMap(m);
    }

    private static abstract class Function {
        private Function() {
        }

        abstract String apply(String var1);
    }

    private static class Parameter
    extends Format {
        private final String name;
        private final List<Function> functions;

        Parameter(String parameter) {
            List<String> names = Arrays.asList(parameter.split("\\."));
            ArrayList<Function> functs = new ArrayList<Function>(names.size());
            if (names.isEmpty()) {
                this.name = "";
            } else {
                this.name = names.get(0);
                for (String fname : names.subList(1, names.size())) {
                    Function function = (Function)FUNCTIONS.get(fname);
                    if (function == null) continue;
                    functs.add(function);
                }
            }
            this.functions = Collections.unmodifiableList(functs);
        }

        @Override
        void format(StringBuilder b, Map<String, String> p) {
            String v = p.get(this.name);
            if (v == null) {
                v = "";
            }
            for (Function function : this.functions) {
                v = function.apply(v);
            }
            b.append(v);
        }
    }

    private static class Constant
    extends Format {
        private final String text;

        Constant(String text) {
            this.text = text;
        }

        @Override
        void format(StringBuilder b, Map<String, String> p) {
            b.append(this.text);
        }
    }

    private static abstract class Format {
        private Format() {
        }

        abstract void format(StringBuilder var1, Map<String, String> var2);
    }

    public final class Builder {
        private final Map<String, String> params = new HashMap<String, String>();

        public Builder replace(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public String toString() {
            return ParameterizedString.this.replace(this.params);
        }
    }
}

