/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.prettify.common.EditList;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import java.util.List;
import org.eclipse.jgit.diff.Edit;

public class PatchScript {
    protected Change.Key changeId;
    protected Patch.ChangeType changeType;
    protected String oldName;
    protected String newName;
    protected FileMode oldMode;
    protected FileMode newMode;
    protected List<String> header;
    protected AccountDiffPreference diffPrefs;
    protected SparseFileContent a;
    protected SparseFileContent b;
    protected List<Edit> edits;
    protected DisplayMethod displayMethodA;
    protected DisplayMethod displayMethodB;
    protected transient String mimeTypeA;
    protected transient String mimeTypeB;
    protected CommentDetail comments;
    protected List<Patch> history;
    protected boolean hugeFile;
    protected boolean intralineDifference;
    protected boolean intralineFailure;
    protected boolean intralineTimeout;

    public PatchScript(Change.Key ck, Patch.ChangeType ct, String on, String nn, FileMode om, FileMode nm, List<String> h, AccountDiffPreference dp, SparseFileContent ca, SparseFileContent cb, List<Edit> e, DisplayMethod ma, DisplayMethod mb, String mta, String mtb, CommentDetail cd, List<Patch> hist, boolean hf, boolean id, boolean idf, boolean idt) {
        this.changeId = ck;
        this.changeType = ct;
        this.oldName = on;
        this.newName = nn;
        this.oldMode = om;
        this.newMode = nm;
        this.header = h;
        this.diffPrefs = dp;
        this.a = ca;
        this.b = cb;
        this.edits = e;
        this.displayMethodA = ma;
        this.displayMethodB = mb;
        this.mimeTypeA = mta;
        this.mimeTypeB = mtb;
        this.comments = cd;
        this.history = hist;
        this.hugeFile = hf;
        this.intralineDifference = id;
        this.intralineFailure = idf;
        this.intralineTimeout = idt;
    }

    protected PatchScript() {
    }

    public Change.Key getChangeId() {
        return this.changeId;
    }

    public DisplayMethod getDisplayMethodA() {
        return this.displayMethodA;
    }

    public DisplayMethod getDisplayMethodB() {
        return this.displayMethodB;
    }

    public FileMode getFileModeA() {
        return this.oldMode;
    }

    public FileMode getFileModeB() {
        return this.newMode;
    }

    public List<String> getPatchHeader() {
        return this.header;
    }

    public Patch.ChangeType getChangeType() {
        return this.changeType;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public CommentDetail getCommentDetail() {
        return this.comments;
    }

    public List<Patch> getHistory() {
        return this.history;
    }

    public AccountDiffPreference getDiffPrefs() {
        return this.diffPrefs;
    }

    public void setDiffPrefs(AccountDiffPreference dp) {
        this.diffPrefs = dp;
    }

    public boolean isHugeFile() {
        return this.hugeFile;
    }

    public boolean isIgnoreWhitespace() {
        return this.diffPrefs.getIgnoreWhitespace() != AccountDiffPreference.Whitespace.IGNORE_NONE;
    }

    public boolean hasIntralineDifference() {
        return this.intralineDifference;
    }

    public boolean hasIntralineFailure() {
        return this.intralineFailure;
    }

    public boolean hasIntralineTimeout() {
        return this.intralineTimeout;
    }

    public boolean isExpandAllComments() {
        return this.diffPrefs.isExpandAllComments();
    }

    public SparseFileContent getA() {
        return this.a;
    }

    public SparseFileContent getB() {
        return this.b;
    }

    public String getMimeTypeA() {
        return this.mimeTypeA;
    }

    public String getMimeTypeB() {
        return this.mimeTypeB;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public Iterable<EditList.Hunk> getHunks() {
        int ctx = this.diffPrefs.getContext();
        if (ctx == -1) {
            ctx = Math.max(this.a.size(), this.b.size());
        }
        return new EditList(this.edits, ctx, this.a.size(), this.b.size()).getHunks();
    }

    public static enum FileMode {
        FILE,
        SYMLINK,
        GITLINK;

    }

    public static enum DisplayMethod {
        NONE,
        DIFF,
        IMG;

    }
}

