/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.Permission;
import java.util.ArrayList;
import java.util.List;

public class PermissionRange
implements Comparable<PermissionRange> {
    protected String name;
    protected int min;
    protected int max;

    protected PermissionRange() {
    }

    public PermissionRange(String name, int min, int max) {
        this.name = name;
        if (min <= max) {
            this.min = min;
            this.max = max;
        } else {
            this.min = max;
            this.max = min;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isLabel() {
        return Permission.isLabel(this.getName());
    }

    public String getLabel() {
        return Permission.extractLabel(this.getName());
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean contains(int value) {
        return this.getMin() <= value && value <= this.getMax();
    }

    public int squash(int value) {
        return Math.min(Math.max(this.getMin(), value), this.getMax());
    }

    public boolean isEmpty() {
        return this.getMin() == 0 && this.getMax() == 0;
    }

    @Override
    public int compareTo(PermissionRange o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.getMin() < 0 && this.getMax() == 0) {
            r.append(this.getMin());
            r.append(' ');
        } else {
            if (this.getMin() != this.getMax()) {
                if (0 <= this.getMin()) {
                    r.append('+');
                }
                r.append(this.getMin());
                r.append("..");
            }
            if (0 <= this.getMax()) {
                r.append('+');
            }
            r.append(this.getMax());
            r.append(' ');
        }
        return r.toString();
    }

    public static class WithDefaults
    extends PermissionRange {
        protected int defaultMin;
        protected int defaultMax;

        protected WithDefaults() {
        }

        public WithDefaults(String name, int min, int max, int defMin, int defMax) {
            super(name, min, max);
            this.setDefaultRange(defMin, defMax);
        }

        public int getDefaultMin() {
            return this.defaultMin;
        }

        public int getDefaultMax() {
            return this.defaultMax;
        }

        public void setDefaultRange(int min, int max) {
            this.defaultMin = min;
            this.defaultMax = max;
        }

        public List<Integer> getValuesAsList() {
            ArrayList<Integer> r = new ArrayList<Integer>(this.getRangeSize());
            for (int i = this.min; i <= this.max; ++i) {
                r.add(i);
            }
            return r;
        }

        public int getRangeSize() {
            return this.max - this.min;
        }
    }
}

