/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.util.List;

class DynamicItemProvider<T>
implements Provider<DynamicItem<T>> {
    private final TypeLiteral<T> type;
    private final Key<DynamicItem<T>> key;
    @Inject
    private Injector injector;

    DynamicItemProvider(TypeLiteral<T> type, Key<DynamicItem<T>> key) {
        this.type = type;
        this.key = key;
    }

    @Override
    public DynamicItem<T> get() {
        return new DynamicItem<T>(this.key, DynamicItemProvider.find(this.injector, this.type), "gerrit");
    }

    private static <T> Provider<T> find(Injector src, TypeLiteral<T> type) {
        List<Binding<T>> bindings = src.findBindingsByType(type);
        if (bindings != null && bindings.size() == 1) {
            return bindings.get(0).getProvider();
        }
        if (bindings != null && bindings.size() > 1) {
            throw new ProvisionException(String.format("Multiple providers bound for DynamicItem<%s>\nThis is not allowed; check the server configuration.", type));
        }
        return null;
    }
}

