/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicMapImpl;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.List;

class DynamicMapProvider<T>
implements Provider<DynamicMap<T>> {
    private final TypeLiteral<T> type;
    @Inject
    private Injector injector;

    DynamicMapProvider(TypeLiteral<T> type) {
        this.type = type;
    }

    @Override
    public DynamicMap<T> get() {
        PrivateInternals_DynamicMapImpl<T> m = new PrivateInternals_DynamicMapImpl<T>();
        List<Binding<T>> bindings = this.injector.findBindingsByType(this.type);
        if (bindings != null) {
            for (Binding<T> b : bindings) {
                if (b.getKey().getAnnotation() == null) continue;
                m.put("gerrit", b.getKey(), b.getProvider());
            }
        }
        return m;
    }
}

