/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicMapImpl;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrivateInternals_DynamicTypes {
    public static Map<TypeLiteral<?>, DynamicItem<?>> dynamicItemsOf(Injector src) {
        Map<TypeLiteral<?>, DynamicItem> m = PrivateInternals_DynamicTypes.newHashMap();
        for (Map.Entry<Key<?>, Binding<?>> e : src.getBindings().entrySet()) {
            TypeLiteral<?> type = e.getKey().getTypeLiteral();
            if (type.getRawType() != DynamicItem.class) continue;
            ParameterizedType p = (ParameterizedType)type.getType();
            m.put(TypeLiteral.get(p.getActualTypeArguments()[0]), (DynamicItem)e.getValue().getProvider().get());
        }
        if (m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static Map<TypeLiteral<?>, DynamicSet<?>> dynamicSetsOf(Injector src) {
        Map<TypeLiteral<?>, DynamicSet> m = PrivateInternals_DynamicTypes.newHashMap();
        for (Map.Entry<Key<?>, Binding<?>> e : src.getBindings().entrySet()) {
            TypeLiteral<?> type = e.getKey().getTypeLiteral();
            if (type.getRawType() != DynamicSet.class) continue;
            ParameterizedType p = (ParameterizedType)type.getType();
            m.put(TypeLiteral.get(p.getActualTypeArguments()[0]), (DynamicSet)e.getValue().getProvider().get());
        }
        if (m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static Map<TypeLiteral<?>, DynamicMap<?>> dynamicMapsOf(Injector src) {
        Map<TypeLiteral<?>, DynamicMap> m = PrivateInternals_DynamicTypes.newHashMap();
        for (Map.Entry<Key<?>, Binding<?>> e : src.getBindings().entrySet()) {
            TypeLiteral<?> type = e.getKey().getTypeLiteral();
            if (type.getRawType() != DynamicMap.class) continue;
            ParameterizedType p = (ParameterizedType)type.getType();
            m.put(TypeLiteral.get(p.getActualTypeArguments()[0]), (DynamicMap)e.getValue().getProvider().get());
        }
        if (m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static List<RegistrationHandle> attachItems(Injector src, Map<TypeLiteral<?>, DynamicItem<?>> items, String pluginName) {
        if (src == null || items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationHandle> handles = new ArrayList<RegistrationHandle>(4);
        try {
            for (Map.Entry<TypeLiteral<?>, DynamicItem<?>> e : items.entrySet()) {
                TypeLiteral<?> type = e.getKey();
                DynamicItem<?> item = e.getValue();
                for (Binding<?> b : PrivateInternals_DynamicTypes.bindings(src, type)) {
                    if (b.getKey().getAnnotation() == null) continue;
                    handles.add(item.set(b.getKey(), b.getProvider(), pluginName));
                }
            }
        }
        catch (RuntimeException e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        catch (Error e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        return handles;
    }

    public static List<RegistrationHandle> attachSets(Injector src, Map<TypeLiteral<?>, DynamicSet<?>> sets) {
        if (src == null || sets == null || sets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationHandle> handles = new ArrayList<RegistrationHandle>(4);
        try {
            for (Map.Entry<TypeLiteral<?>, DynamicSet<?>> e : sets.entrySet()) {
                TypeLiteral<?> type = e.getKey();
                DynamicSet<?> set = e.getValue();
                for (Binding<?> b : PrivateInternals_DynamicTypes.bindings(src, type)) {
                    if (b.getKey().getAnnotation() == null) continue;
                    handles.add(set.add(b.getKey(), b.getProvider()));
                }
            }
        }
        catch (RuntimeException e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        catch (Error e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        return handles;
    }

    public static List<RegistrationHandle> attachMaps(Injector src, String groupName, Map<TypeLiteral<?>, DynamicMap<?>> maps) {
        if (src == null || maps == null || maps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationHandle> handles = new ArrayList<RegistrationHandle>(4);
        try {
            for (Map.Entry<TypeLiteral<?>, DynamicMap<?>> e : maps.entrySet()) {
                TypeLiteral<?> type = e.getKey();
                PrivateInternals_DynamicMapImpl set = (PrivateInternals_DynamicMapImpl)e.getValue();
                for (Binding<?> b : PrivateInternals_DynamicTypes.bindings(src, type)) {
                    if (b.getKey().getAnnotation() == null) continue;
                    handles.add(set.put(groupName, b.getKey(), b.getProvider()));
                }
            }
        }
        catch (RuntimeException e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        catch (Error e) {
            PrivateInternals_DynamicTypes.remove(handles);
            throw e;
        }
        return handles;
    }

    public static LifecycleListener registerInParentInjectors() {
        return new LifecycleListener(){
            private List<RegistrationHandle> handles;
            @Inject
            private Injector self;

            @Override
            public void start() {
                this.handles = new ArrayList<RegistrationHandle>(4);
                for (Injector parent = this.self.getParent(); parent != null; parent = parent.getParent()) {
                    this.handles.addAll(PrivateInternals_DynamicTypes.attachSets(this.self, PrivateInternals_DynamicTypes.dynamicSetsOf(parent)));
                    this.handles.addAll(PrivateInternals_DynamicTypes.attachMaps(this.self, "gerrit", PrivateInternals_DynamicTypes.dynamicMapsOf(parent)));
                }
                if (this.handles.isEmpty()) {
                    this.handles = null;
                }
            }

            @Override
            public void stop() {
                PrivateInternals_DynamicTypes.remove(this.handles);
                this.handles = null;
            }
        };
    }

    private static void remove(List<RegistrationHandle> handles) {
        if (handles != null) {
            for (RegistrationHandle handle : handles) {
                handle.remove();
            }
        }
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    private static <T> List<Binding<T>> bindings(Injector src, TypeLiteral<T> type) {
        return src.findBindingsByType(type);
    }
}

