/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.restapi;

import com.google.gerrit.extensions.restapi.CacheControl;

public abstract class Response<T> {
    private static final Response NONE = new None();

    public static <T> Response<T> ok(T value) {
        return new Impl(200, value);
    }

    public static <T> Response<T> created(T value) {
        return new Impl(201, value);
    }

    public static <T> Response<T> none() {
        return NONE;
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static <T> T unwrap(T obj) {
        while (obj instanceof Response) {
            obj = ((Response)obj).value();
        }
        return obj;
    }

    public abstract int statusCode();

    public abstract T value();

    public abstract CacheControl caching();

    public abstract Response<T> caching(CacheControl var1);

    public abstract String toString();

    public static final class Redirect {
        private final String location;

        private Redirect(String url) {
            this.location = url;
        }

        public String location() {
            return this.location;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Redirect && ((Redirect)o).location.equals(this.location);
        }

        public String toString() {
            return String.format("[302 Redirect] %s", this.location);
        }
    }

    private static final class None
    extends Response<Object> {
        private None() {
        }

        @Override
        public int statusCode() {
            return 204;
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheControl caching() {
            return CacheControl.NONE;
        }

        @Override
        public Response<Object> caching(CacheControl c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return "[204 No Content] None";
        }
    }

    private static final class Impl<T>
    extends Response<T> {
        private final int statusCode;
        private final T value;
        private CacheControl caching = CacheControl.NONE;

        private Impl(int sc, T val) {
            this.statusCode = sc;
            this.value = val;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public CacheControl caching() {
            return this.caching;
        }

        @Override
        public Response<T> caching(CacheControl c) {
            this.caching = c;
            return this;
        }

        @Override
        public String toString() {
            return "[" + this.statusCode() + "] " + this.value();
        }
    }
}

