/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.CharMatcher;
import com.google.gerrit.common.PageLinks;
import com.google.gerrit.httpd.UrlModule;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class DirectChangeByCommit
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DirectChangeByCommit.class);
    private final ChangeQueryBuilder.Factory queryBuilder;
    private final Provider<ChangeQueryRewriter> queryRewriter;
    private final Provider<CurrentUser> currentUser;

    @Inject
    DirectChangeByCommit(ChangeQueryBuilder.Factory queryBuilder, Provider<ChangeQueryRewriter> queryRewriter, Provider<CurrentUser> currentUser) {
        this.queryBuilder = queryBuilder;
        this.queryRewriter = queryRewriter;
        this.currentUser = currentUser;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String query = CharMatcher.is('/').trimTrailingFrom(req.getPathInfo());
        HashSet<Change.Id> ids = new HashSet<Change.Id>();
        try {
            ChangeQueryBuilder builder = this.queryBuilder.create(this.currentUser.get());
            Predicate<ChangeData> visibleToMe = builder.is_visible();
            Predicate<ChangeData> q = builder.parse(query);
            q = Predicate.and(q, builder.sortkey_before("z"), builder.limit(2), visibleToMe);
            ChangeQueryRewriter rewriter = this.queryRewriter.get();
            Predicate<ChangeData> s = rewriter.rewrite(q, 0);
            if (!(s instanceof ChangeDataSource)) {
                s = rewriter.rewrite(Predicate.and(builder.status_open(), q), 0);
            }
            if (s instanceof ChangeDataSource) {
                for (ChangeData d : ((ChangeDataSource)((Object)s)).read()) {
                    ids.add(d.getId());
                }
            }
        }
        catch (QueryParseException e) {
            log.info("Received invalid query by URL: /r/" + query);
        }
        catch (OrmException e) {
            log.warn("Cannot process query by URL: /r/" + query, e);
        }
        String token = ids.size() == 1 ? PageLinks.toChange((Change.Id)ids.iterator().next()) : PageLinks.toChangeQuery(query);
        UrlModule.toGerrit(token, req, rsp);
    }
}

