/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.ContainerAuthFilter;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.httpd.ProjectBasicAuthFilter;
import com.google.gerrit.httpd.ProjectDigestFilter;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.servlet.ServletModule;

public class GitOverHttpModule
extends ServletModule {
    private final AuthConfig authConfig;

    @Inject
    GitOverHttpModule(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    protected void configureServlets() {
        Class authFilter = this.authConfig.isTrustContainerAuth() ? ContainerAuthFilter.class : (this.authConfig.isGitBasicAuth() ? ProjectBasicAuthFilter.class : ProjectDigestFilter.class);
        String git = GitOverHttpServlet.URL_REGEX;
        this.filterRegex(git, new String[0]).through(authFilter);
        this.serveRegex(git, new String[0]).with(GitOverHttpServlet.class);
        this.filter("/a/*", new String[0]).through(authFilter);
    }
}

