/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.data.GitWebType;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import java.io.File;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitWebConfig {
    private static final Logger log = LoggerFactory.getLogger(GitWebConfig.class);
    private final String url;
    private final File gitweb_cgi;
    private final File gitweb_css;
    private final File gitweb_js;
    private final File git_logo_png;
    private GitWebType type;

    @Inject
    GitWebConfig(SitePaths sitePaths, @GerritServerConfig Config cfg) {
        File cgi;
        String cfgUrl = cfg.getString("gitweb", null, "url");
        String cfgCgi = cfg.getString("gitweb", null, "cgi");
        this.type = GitWebType.fromName(cfg.getString("gitweb", null, "type"));
        if (this.type == null) {
            this.url = null;
            this.gitweb_cgi = null;
            this.gitweb_css = null;
            this.gitweb_js = null;
            this.git_logo_png = null;
            return;
        }
        this.type.setLinkName(cfg.getString("gitweb", null, "linkname"));
        this.type.setBranch(cfg.getString("gitweb", null, "branch"));
        this.type.setProject(cfg.getString("gitweb", null, "project"));
        this.type.setRevision(cfg.getString("gitweb", null, "revision"));
        this.type.setRootTree(cfg.getString("gitweb", null, "roottree"));
        this.type.setFile(cfg.getString("gitweb", null, "file"));
        this.type.setFileHistory(cfg.getString("gitweb", null, "filehistory"));
        this.type.setLinkDrafts(cfg.getBoolean("gitweb", null, "linkdrafts", true));
        this.type.setUrlEncode(cfg.getBoolean("gitweb", null, "urlencode", true));
        String pathSeparator = cfg.getString("gitweb", null, "pathSeparator");
        if (pathSeparator != null) {
            if (pathSeparator.length() == 1) {
                char c = pathSeparator.charAt(0);
                if (GitWebConfig.isValidPathSeparator(c)) {
                    this.type.setPathSeparator(c);
                } else {
                    log.warn("Invalid value specified for gitweb.pathSeparator: " + c);
                }
            } else {
                log.warn("Value specified for gitweb.pathSeparator is not a single character:" + pathSeparator);
            }
        }
        if (this.type.getBranch() == null) {
            log.warn("No Pattern specified for gitweb.branch, disabling.");
            this.type = null;
        } else if (this.type.getProject() == null) {
            log.warn("No Pattern specified for gitweb.project, disabling.");
            this.type = null;
        } else if (this.type.getRevision() == null) {
            log.warn("No Pattern specified for gitweb.revision, disabling.");
            this.type = null;
        } else if (this.type.getRootTree() == null) {
            log.warn("No Pattern specified for gitweb.roottree, disabling.");
            this.type = null;
        } else if (this.type.getFile() == null) {
            log.warn("No Pattern specified for gitweb.file, disabling.");
            this.type = null;
        } else if (this.type.getFileHistory() == null) {
            log.warn("No Pattern specified for gitweb.filehistory, disabling.");
            this.type = null;
        }
        if (cfgUrl != null && cfgUrl.isEmpty() || cfgCgi != null && cfgCgi.isEmpty()) {
            this.url = null;
            this.gitweb_cgi = null;
            this.gitweb_css = null;
            this.gitweb_js = null;
            this.git_logo_png = null;
            return;
        }
        if (cfgUrl != null && (cfgCgi == null || cfgCgi.isEmpty())) {
            this.url = cfgUrl;
            this.gitweb_cgi = null;
            this.gitweb_css = null;
            this.gitweb_js = null;
            this.git_logo_png = null;
            return;
        }
        File pkgCgi = new File("/usr/lib/cgi-bin/gitweb.cgi");
        String[] resourcePaths = new String[]{"/usr/share/gitweb/static", "/usr/share/gitweb", "/var/www/static", "/var/www"};
        if (cfgCgi != null) {
            cgi = sitePaths.resolve(cfgCgi);
            if (!cgi.isFile()) {
                throw new IllegalStateException("Cannot find gitweb.cgi: " + cgi);
            }
            if (!cgi.canExecute()) {
                throw new IllegalStateException("Cannot execute gitweb.cgi: " + cgi);
            }
            if (!cgi.equals(pkgCgi)) {
                String absPath = cgi.getParentFile().getAbsolutePath();
                resourcePaths = new String[]{absPath + "/static", absPath};
            }
        } else if (pkgCgi.isFile() && pkgCgi.canExecute()) {
            log.debug("Assuming gitweb at " + pkgCgi);
            cgi = pkgCgi;
        } else {
            log.warn("gitweb not installed (no " + pkgCgi + " found)");
            cgi = null;
            resourcePaths = new String[]{};
        }
        File css = null;
        File js = null;
        File logo = null;
        for (String path : resourcePaths) {
            File dir = new File(path);
            css = new File(dir, "gitweb.css");
            js = new File(dir, "gitweb.js");
            logo = new File(dir, "git-logo.png");
            if (css.isFile() && logo.isFile()) break;
        }
        this.url = cfgUrl == null || cfgUrl.isEmpty() ? (cgi != null ? "gitweb" : null) : (cgi != null ? cfgUrl : null);
        this.gitweb_cgi = cgi;
        this.gitweb_css = css;
        this.gitweb_js = js;
        this.git_logo_png = logo;
    }

    public GitWebType getGitWebType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public File getGitwebCGI() {
        return this.gitweb_cgi;
    }

    public File getGitwebCSS() {
        return this.gitweb_css;
    }

    public File getGitwebJS() {
        return this.gitweb_js;
    }

    public File getGitLogoPNG() {
        return this.git_logo_png;
    }

    static boolean isValidPathSeparator(char c) {
        switch (c) {
            case '(': 
            case ')': 
            case '*': {
                return true;
            }
        }
        return false;
    }
}

